/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.block.model.ItemTransforms.TypeConverter;
import moe.plushie.armourers_workshop.core.client.model.BakedModelStorage;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Inject(method={"getModel"}, at={@At(value="RETURN")}, cancellable=true)
    private void aw2$getModel(ItemStack itemStack, Level level, LivingEntity entity, int i, CallbackInfoReturnable<BakedModel> cir) {
        BakedModel bakedModel = (BakedModel)cir.getReturnValue();
        EmbeddedSkinStack embeddedStack = ClientWardrobeHandler.getEmbeddedSkinStack(entity, level, itemStack, null);
        if (embeddedStack != null) {
            cir.setReturnValue((Object)BakedModelStorage.wrap(bakedModel, itemStack, embeddedStack, entity, level));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void aw2$render(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean p_229111_3_, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int overlay, BakedModel bakedModel, CallbackInfo ci) {
        BakedModelStorage storage = BakedModelStorage.unwrap(bakedModel);
        if (storage == null) {
            return;
        }
        BakedModel resolvedModel = storage.getOriginModel();
        LivingEntity entity = storage.getEntity();
        Level level = storage.getLevel();
        EmbeddedSkinStack embeddedStack = storage.getEmbeddedStack();
        ClientWardrobeHandler.renderEmbeddedSkin(entity, level, itemStack, embeddedStack, TypeConverter.ofType(ItemTransforms.class, transformType), p_229111_3_, poseStack, buffers, resolvedModel, packedLight, overlay, ci);
    }

    @Inject(method={"renderGuiItem(Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="HEAD")})
    private void aw2$renderGuiItemPre(ItemStack itemStack, int i, int j, CallbackInfo ci) {
        ClientWardrobeHandler.startRenderGuiItem(itemStack);
    }

    @Inject(method={"renderGuiItem(Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="RETURN")})
    private void aw2$renderGuiItemPost(ItemStack itemStack, int i, int j, CallbackInfo ci) {
        ClientWardrobeHandler.endRenderGuiItem(itemStack);
    }

    @Inject(method={"tryRenderGuiItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="HEAD")})
    private void aw2$tryRenderGuiItemPre(LivingEntity livingEntity, ItemStack itemStack, int i, int j, int k, int l, CallbackInfo ci) {
        ClientWardrobeHandler.startRenderGuiItem(itemStack);
    }

    @Inject(method={"tryRenderGuiItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;III)V"}, at={@At(value="RETURN")})
    private void aw2$tryRenderGuiItemPost(LivingEntity livingEntity, ItemStack itemStack, int i, int j, int k, CallbackInfo ci) {
        ClientWardrobeHandler.endRenderGuiItem(itemStack);
    }
}

