/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.common.ITagRepresentable;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class AbstractForgeCapabilityManager {
    public static <T> IRegistryKey<ICapabilityType<T>> register(String name, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (type == SkinWardrobe.class) {
            return (IRegistryKey)ObjectUtils.unsafeCast(AbstractForgeCapabilityManager.createWardrobeCapabilityType(name, (Function)ObjectUtils.unsafeCast(factory)));
        }
        throw new AssertionError();
    }

    private static IRegistryKey<ICapabilityType<SkinWardrobe>> createWardrobeCapabilityType(String registryName, Function<Entity, Optional<SkinWardrobe>> provider) {
        ResourceLocation name = ModConstants.key(registryName);
        Capability capability = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkinWardrobe>(){});
        ICapabilityType capabilityType = entity -> entity.getCapability(capability).resolve();
        return new RegistryObjectProxy(name, SkinWardrobe.class, provider, capabilityType, () -> capability);
    }

    public static class RegistryObjectProxy<N extends CompoundTag, T extends ITagRepresentable<N>>
    implements IRegistryKey<ICapabilityType<T>> {
        final ResourceLocation registryName;
        final Supplier<Capability<T>> capability;
        final Class<T> type;
        final ICapabilityType<T> capabilityType;
        final Function<Entity, Optional<T>> factory;

        protected RegistryObjectProxy(ResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory, ICapabilityType<T> capabilityType, Supplier<Capability<T>> capability) {
            this.type = type;
            this.factory = factory;
            this.capability = capability;
            this.capabilityType = capabilityType;
            this.registryName = registryName;
            this.setupBus();
        }

        public void setupBus() {
            MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::attachEntityCapability);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapability);
        }

        public void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(this.type);
        }

        public void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
            Optional<T> value = this.factory.apply((Entity)event.getObject());
            if (!value.isPresent()) {
                return;
            }
            event.addCapability(this.registryName, (ICapabilityProvider)new CapabilityProviderProxy<N, T>((ITagRepresentable)value.get()){

                @Override
                public Capability<T> getCapability() {
                    return capability.get();
                }
            });
        }

        @Override
        public ICapabilityType<T> get() {
            return this.capabilityType;
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.registryName;
        }
    }

    public static abstract class CapabilityProviderProxy<N extends CompoundTag, T extends ITagRepresentable<N>>
    implements ICapabilityProvider,
    INBTSerializable<N> {
        protected final T value;

        protected CapabilityProviderProxy(T value) {
            this.value = value;
        }

        public N serializeNBT() {
            return (N)((CompoundTag)this.value.serializeNBT());
        }

        public void deserializeNBT(N nbt) {
            this.value.deserializeNBT(nbt);
        }

        public <I> LazyOptional<I> getCapability(Capability<I> cap, @Nullable Direction arg) {
            return this.getCapability().orEmpty(cap, LazyOptional.of(() -> this.value));
        }

        public abstract Capability<T> getCapability();
    }
}

