/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUndoAction;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CubeChanges
implements IUndoAction,
IWorldUpdateTask {
    private final Level level;
    private final BlockPos blockPos;
    private BlockState blockState;
    private CompoundTag nbt;
    private Map<Direction, IPaintColor> colors;

    public CubeChanges(Level level, BlockPos blockPos) {
        this.level = level;
        this.blockPos = blockPos;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public void setCompoundTag(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public void setColor(Direction dir, IPaintColor color) {
        if (this.colors == null) {
            this.colors = new HashMap<Direction, IPaintColor>();
        }
        this.colors.put(dir, color);
    }

    public void setColors(Map<Direction, IPaintColor> colors) {
        this.colors = colors;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    private boolean isChangeNBT() {
        return this.nbt != null || this.colors != null;
    }

    @Override
    public void prepare() throws CommandRuntimeException {
        if (!this.isChangeNBT()) {
            return;
        }
        if (this.blockState != null) {
            return;
        }
        BlockEntity blockEntity = this.level.m_7702_(this.blockPos);
        if (blockEntity == null) {
            String value = String.format("x=%d, y=%d, z=%d", this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_());
            throw new CommandRuntimeException((Component)Component.m_237110_((String)"chat.armourers_workshop.undo.missingBlock", (Object[])new Object[]{value}));
        }
    }

    @Override
    public IUndoAction apply() throws CommandRuntimeException {
        BlockEntity blockEntity2;
        boolean isChangedNBT = false;
        CubeChanges changes = new CubeChanges(this.level, this.blockPos);
        if (this.blockState != null) {
            changes.setBlockState(this.level.m_8055_(this.blockPos));
            isChangedNBT = true;
        }
        if (this.nbt != null) {
            isChangedNBT = true;
        }
        if (isChangedNBT) {
            ObjectUtils.ifPresent(this.level.m_7702_(this.blockPos), blockEntity -> {
                CompoundTag newTag = blockEntity.m_187480_();
                changes.setCompoundTag(newTag);
            });
        } else if (this.colors != null && (blockEntity2 = this.level.m_7702_(this.blockPos)) instanceof IPaintable) {
            IPaintable target = (IPaintable)blockEntity2;
            HashMap<Direction, IPaintColor> oldValue = new HashMap<Direction, IPaintColor>();
            for (Direction direction : this.colors.keySet()) {
                IPaintColor paintColor = target.getColor(direction);
                if (paintColor == null) {
                    paintColor = PaintColor.CLEAR;
                }
                oldValue.put(direction, paintColor);
            }
            changes.setColors(oldValue);
        }
        WorldUpdater.getInstance().submit(this);
        return changes;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public InteractionResult run(Level level) {
        if (!level.m_46749_(this.blockPos)) {
            return InteractionResult.PASS;
        }
        int changes = 0;
        if (this.blockState != null && !this.blockState.equals(level.m_8055_(this.blockPos))) {
            level.m_7731_(this.blockPos, this.blockState, 3);
            ++changes;
        }
        BlockEntity blockEntity = null;
        if (this.isChangeNBT()) {
            blockEntity = level.m_7702_(this.blockPos);
        }
        if (this.nbt != null && blockEntity != null) {
            blockEntity.m_142466_(this.nbt);
            ++changes;
        }
        if (this.colors != null && blockEntity instanceof IPaintable) {
            ((IPaintable)blockEntity).setColors(this.colors);
            ++changes;
        }
        if (changes == 0) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

