/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends BlockItem
implements IItemColorProvider,
IPaintToolPicker {
    public SkinCubeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public InteractionResult usePickTool(Level level, BlockPos pos, Direction dir, BlockEntity blockEntity, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (blockEntity instanceof IPaintProvider) {
            this.setItemColor(itemStack, ((IPaintProvider)blockEntity).getColor());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag nbt = itemStack.m_41737_("BlockEntityTag");
        if (nbt != null && blockEntity != null) {
            CompoundTag newNBT = blockEntity.m_187480_();
            newNBT.m_128365_("Color", (Tag)nbt.m_128469_("Color"));
            blockEntity.m_142466_(newNBT);
        }
        return super.m_7274_(pos, level, player, itemStack, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltips, TooltipFlag flags) {
        super.m_7373_(itemStack, level, tooltips, flags);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(Direction.NORTH), true));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, IPaintColor paintColor) {
        CompoundTag nbt = itemStack.m_41698_("BlockEntityTag");
        BlockPaintColor color = new BlockPaintColor(paintColor);
        OptionalAPI.putOptionalBlockPaintColor(nbt, "Color", color, null);
        itemStack.m_41700_("Flags", (Tag)IntTag.m_128679_((int)1));
    }

    @Override
    public IPaintColor getItemColor(ItemStack itemStack) {
        return (IPaintColor)ObjectUtils.defaultIfNull((Object)ColorUtils.getColor(itemStack), (Object)PaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(ItemStack itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

