/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.properties;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.data.IDataProperty;
import moe.plushie.armourers_workshop.builder.data.properties.FloatProperty;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import org.jetbrains.annotations.Nullable;

public class VectorProperty
implements IDataProperty<Vector3f> {
    private Vector3f vectorValue;

    @Override
    public void set(Vector3f value) {
        this.vectorValue = value;
    }

    @Override
    public Vector3f get() {
        return this.vectorValue;
    }

    public FloatProperty x() {
        return this.field(Vector3f::setX, Vector3f::getX);
    }

    public FloatProperty y() {
        return this.field(Vector3f::setY, Vector3f::getY);
    }

    public FloatProperty z() {
        return this.field(Vector3f::setZ, Vector3f::getZ);
    }

    private FloatProperty field(final BiConsumer<Vector3f, Float> setter, final Function<Vector3f, Float> getter) {
        return new FloatProperty(){

            @Override
            public void set(Float value) {
                Vector3f newValue = VectorProperty.this.vectorValue.copy();
                setter.accept(newValue, value);
                VectorProperty.this.vectorValue = newValue;
            }

            @Override
            @Nullable
            public Float get() {
                if (VectorProperty.this.vectorValue != null) {
                    return (Float)getter.apply(VectorProperty.this.vectorValue);
                }
                return null;
            }
        };
    }
}

