/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCubeBlockEntityRenderer<T extends BlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private static float markerAlpha = 0.0f;
    private static long lastWorldTimeUpdate;

    public SkinCubeBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public static void updateAlpha(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null || lastWorldTimeUpdate == level.m_46467_()) {
            return;
        }
        lastWorldTimeUpdate = level.m_46467_();
        if (SkinCubeBlockEntityRenderer.isPlayerHoldingPaintingTool()) {
            if ((markerAlpha += 0.25f) > 1.0f) {
                markerAlpha = 1.0f;
            }
        } else if ((markerAlpha -= 0.25f) < 0.0f) {
            markerAlpha = 0.0f;
        }
    }

    private static boolean isPlayerHoldingPaintingTool() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41720_() instanceof IBlockPaintViewer) {
            return true;
        }
        if (itemStack.m_150930_((Item)ModItems.COLOR_PICKER.get())) {
            return true;
        }
        return itemStack.m_150930_((Item)ModItems.SOAP.get());
    }

    @Override
    public void m_6922_(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        SkinCubeBlockEntityRenderer.updateAlpha(entity);
        if (!(markerAlpha > 0.0f)) {
            return;
        }
        int alpha = (int)(markerAlpha * 255.0f);
        VertexConsumer builder = buffers.m_6299_(SkinRenderType.IMAGE_MARKER);
        for (Direction direction : Direction.values()) {
            if (!((IPaintable)entity).shouldChangeColor(direction) || !((IPaintable)entity).hasColor(direction)) continue;
            IPaintColor paintColor = ((IPaintable)entity).getColor(direction);
            ExtendedFaceRenderer.renderMarker(0, 0, 0, direction, paintColor, alpha, light, overlay, poseStack, builder);
        }
    }
}

