/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedSkinBuilderBlockEntityRenderer<T extends AdvancedSkinBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public static ArrayList<Vector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();

    public static void setOutput(int i, Vector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(Vector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedSkinBuilderBlockEntityRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        SkinRenderTesselator tesselator = SkinRenderTesselator.create(((AdvancedSkinBuilderBlockEntity)entity).descriptor, Tickets.RENDERER);
        if (tesselator == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)((AdvancedSkinBuilderBlockEntity)entity).offset.getX(), (double)((AdvancedSkinBuilderBlockEntity)entity).offset.getY(), (double)((AdvancedSkinBuilderBlockEntity)entity).offset.getZ());
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getX(), ((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getY(), ((AdvancedSkinBuilderBlockEntity)entity).carmeScale.getZ());
        poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
        tesselator.setLightmap(0xF000F0);
        tesselator.setPartialTicks(0.0f);
        tesselator.setBuffer(OutlineObjectBuilder.immediate(buffers));
        tesselator.draw(poseStack, buffers);
        poseStack.m_85849_();
        if (ModDebugger.advancedSkinBuilder) {
            BlockState blockState = entity.m_58900_();
            BlockPos pos = entity.m_58899_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
            ShapeTesselator.stroke(((AdvancedSkinBuilderBlockEntity)entity).getCustomRenderBoundingBox(blockState), UIColor.RED, poseStack, buffers);
            Vector3f origin = ((AdvancedSkinBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.m_85837_((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, buffers);
            poseStack.m_85837_((double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getX(), (double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getY(), (double)((AdvancedSkinBuilderBlockEntity)entity).carmeOffset.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, buffers);
            poseStack.m_85849_();
        }
        this.renderOutput(entity, partialTicks, poseStack, buffers, light, overlay);
    }

    public void renderOutput(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        BlockPos pos = entity.m_58899_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        if (OUTPUTS.size() >= 2) {
            Vector3f pt1 = OUTPUTS.get(0);
            Vector3f vector3f = OUTPUTS.get(1);
        }
        poseStack.m_85849_();
    }

    public int m_142163_() {
        return 272;
    }

    public static class OutlineObjectBuilder
    implements SkinRenderBufferSource.ObjectBuilder {
        private final SkinRenderBufferSource.ObjectBuilder builder;

        public OutlineObjectBuilder(SkinRenderBufferSource.ObjectBuilder builder) {
            this.builder = builder;
        }

        public static SkinRenderBufferSource immediate(MultiBufferSource buffers) {
            SkinRenderBufferSource source = SkinRenderBufferSource.immediate(buffers);
            return skin -> new OutlineObjectBuilder(source.getBuffer(skin));
        }

        @Override
        public int addPart(BakedSkinPart bakedPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRender, SkinRenderContext context) {
            int total = 0;
            if (RESULTS.contains(bakedPart)) {
                context.setOverlay(0x38FFFFFF);
                total = this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
                context.setOverlay(0);
            }
            if (total != 0) {
                shouldRender = false;
            }
            return this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
        }

        @Override
        public void addShape(Vector3f origin, SkinRenderContext context) {
            this.builder.addShape(origin, context);
        }

        @Override
        public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
            this.builder.addShape(shape, color, context);
        }

        @Override
        public void addShape(ITransformf[] transforms, SkinRenderContext context) {
            this.builder.addShape(transforms, context);
        }
    }
}

