/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UILabel;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerCopyDialog
extends ConfirmDialog {
    final ArrayList<ISkinPartType> partTypes;
    private final UICheckBox mirrorCheckBox = new UICheckBox(CGRect.ZERO);
    private final UICheckBox paintCheckBox = new UICheckBox(CGRect.ZERO);
    private final UIComboBox sourcePartComboBox = new UIComboBox(new CGRect(0.0f, 0.0f, 100.0f, 14.0f));
    private final UIComboBox destinationPartComboBox = new UIComboBox(new CGRect(0.0f, 0.0f, 100.0f, 14.0f));

    public ArmourerCopyDialog(ArrayList<ISkinPartType> partTypes) {
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 140.0f));
        this.partTypes = partTypes;
        this.setup();
    }

    private void setup() {
        this.layoutIfNeeded();
        float width = this.bounds().width - 30.0f;
        float left = this.confirmButton.frame().getX() + 1.0f;
        float right = this.cancelButton.frame().getMaxX() - 1.0f;
        float bottom = this.confirmButton.frame().getY() - 4.0f;
        this.mirrorCheckBox.setFrame(new CGRect(left, bottom - 22.0f, width, 9.0f));
        this.mirrorCheckBox.setTitle(this.getText("mirror"));
        this.mirrorCheckBox.setSelected(false);
        this.addSubview(this.mirrorCheckBox);
        this.paintCheckBox.setFrame(new CGRect(left, bottom - 11.0f, width, 9.0f));
        this.paintCheckBox.setTitle(this.getText("copyPaint"));
        this.paintCheckBox.setSelected(false);
        this.addSubview(this.paintCheckBox);
        this.sourcePartComboBox.setFrame(new CGRect(left, 35.0f, 100.0f, 14.0f));
        this.sourcePartComboBox.setSelectedIndex(0);
        this.sourcePartComboBox.reloadData(this.getItems(this.partTypes));
        this.addSubview(this.sourcePartComboBox);
        this.destinationPartComboBox.setFrame(new CGRect(right - 100.0f, 35.0f, 100.0f, 14.0f));
        this.destinationPartComboBox.setSelectedIndex(0);
        this.destinationPartComboBox.reloadData(this.getItems(this.partTypes));
        this.addSubview(this.destinationPartComboBox);
        UILabel label1 = new UILabel(new CGRect(this.sourcePartComboBox.frame().getX(), this.sourcePartComboBox.frame().getY() - 10.0f, 100.0f, 9.0f));
        UILabel label2 = new UILabel(new CGRect(this.destinationPartComboBox.frame().getX(), this.destinationPartComboBox.frame().getY() - 10.0f, 100.0f, 9.0f));
        label1.setText(this.getText("srcPart"));
        label2.setText(this.getText("desPart"));
        this.addSubview(label1);
        this.addSubview(label2);
    }

    public ISkinPartType getSourcePartType() {
        if (this.partTypes != null && this.sourcePartComboBox != null && this.sourcePartComboBox.selectedIndex() < this.partTypes.size()) {
            return this.partTypes.get(this.sourcePartComboBox.selectedIndex());
        }
        return SkinPartTypes.UNKNOWN;
    }

    public ISkinPartType getDestinationPartType() {
        if (this.partTypes != null && this.destinationPartComboBox != null && this.destinationPartComboBox.selectedIndex() < this.partTypes.size()) {
            return this.partTypes.get(this.destinationPartComboBox.selectedIndex());
        }
        return SkinPartTypes.UNKNOWN;
    }

    public boolean isMirror() {
        return this.mirrorCheckBox == null || this.mirrorCheckBox.isSelected();
    }

    public boolean isCopyPaintData() {
        return this.paintCheckBox == null || this.paintCheckBox.isSelected();
    }

    private ArrayList<UIComboItem> getItems(ArrayList<ISkinPartType> partTypes) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (ISkinPartType partType : partTypes) {
            NSString title = new NSString((Component)TranslateUtils.Name.of(partType));
            items.add(new UIComboItem(title));
        }
        return items;
    }

    private NSString getText(String key) {
        return new NSString((Component)TranslateUtils.title("inventory.armourers_workshop.armourer.dialog.copy." + key, new Object[0]));
    }
}

