/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSIndexPath;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIBarItem;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.data.AdvancedSkinTypes;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedBonePanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedGeneralPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.DrawerToolbar;
import moe.plushie.armourers_workshop.builder.client.gui.widget.NewComboBox;
import moe.plushie.armourers_workshop.builder.client.gui.widget.NewComboItem;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class AdvancedRightCardPanel
extends UIView {
    private final TreeView rightTree = new TreeView(new CGRect(0.0f, 0.0f, 200.0f, 200.0f));
    private final NewComboBox typeView = new NewComboBox(new CGRect(0.0f, 0.0f, 200.0f, 16.0f));
    private final DrawerToolbar rightToolbar = new DrawerToolbar(new CGRect(0.0f, 0.0f, 200.0f, 480.0f));
    private final ArrayList<AdvancedTypeSection> allSections = new ArrayList();
    private final ArrayList<AdvancedTypeItem> allItems = new ArrayList();
    private AdvancedTypeItem selectedItem;

    public AdvancedRightCardPanel(AdvancedSkinBuilderBlockEntity blockEntity, CGRect frame) {
        super(frame);
        this.init();
        this.setup(blockEntity, frame);
    }

    private void init() {
        AdvancedSkinTypes.forEach((category, items) -> {
            AdvancedTypeSection section = new AdvancedTypeSection((String)category);
            items.forEach(it -> this.allItems.add(section.add(it.getType())));
            this.allSections.add(section);
        });
    }

    private void setup(AdvancedSkinBuilderBlockEntity blockEntity, CGRect rect) {
        float h1 = rect.height * 0.35f;
        float h2 = rect.height * 0.65f;
        UIImage image = UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build();
        UIView bg1 = new UIView(this.bounds().insetBy(4.0f, 4.0f, h2, 4.0f));
        bg1.setContents(image);
        bg1.setAutoresizingMask(34);
        this.addSubview(bg1);
        this.typeView.setFrame(new CGRect(0.0f, 0.0f, bg1.bounds().getWidth(), 20.0f));
        this.typeView.setMaxRows(16);
        this.typeView.setAutoresizingMask(34);
        this.typeView.addTarget(this, UIControl.Event.VALUE_CHANGED, AdvancedRightCardPanel::setSkinTypeWithCombobox);
        this.typeView.reloadData(this.allSections);
        bg1.insertViewAtIndex(this.typeView, 0);
        this.rightTree.setContentInsets(new UIEdgeInsets(4.0f, 0.0f, 4.0f, 0.0f));
        this.rightTree.setFrame(bg1.bounds().insetBy(20.0f, 0.0f, 0.0f, 0.0f));
        this.rightTree.setAutoresizingMask(18);
        bg1.insertViewAtIndex(this.rightTree, 0);
        UIView bg2 = new UIView(this.bounds().insetBy(h1 + 4.0f, 4.0f, 4.0f, 4.0f));
        bg2.setAutoresizingMask(18);
        bg2.setContents(image);
        this.addSubview(bg2);
        this.rightToolbar.setFrame(bg2.bounds().insetBy(0.0f, 0.0f, 0.0f, 0.0f));
        this.rightToolbar.setAutoresizingMask(18);
        bg2.addSubview(this.rightToolbar);
        this.addRightPanel(new AdvancedGeneralPanel(blockEntity));
        this.addRightPanel(new AdvancedBonePanel(blockEntity));
    }

    protected void addRightPanel(AdvancedPanel panel) {
        UIBarItem barItem = panel.barItem();
        panel.setFrame(this.rightToolbar.bounds());
        panel.sizeToFit();
        this.rightToolbar.addPage(panel, barItem);
    }

    public void setSkinTypeWithIndex(int index) {
        this.setSkinTypeWithItem(this.allItems.get(index));
    }

    private void setSkinTypeWithItem(AdvancedTypeItem item) {
        this.selectedItem = item;
        TreeNode rootNode = this.rightTree.rootNode();
        rootNode.clear();
        for (ISkinPartType iSkinPartType : item.getSkinType().getParts()) {
            NSMutableString name = new NSMutableString("Root - ");
            name.append((Component)TranslateUtils.Name.of(iSkinPartType));
            rootNode.add(new TreeNode(name));
        }
        rootNode.add(new TreeNode(new NSString("Root - Float")));
        rootNode.add(new TreeNode(new NSString("Root - Static")));
    }

    private void setSkinTypeWithCombobox(UIControl sender) {
        NSIndexPath indexPath = this.typeView.selectedIndex();
        AdvancedTypeSection section = this.allSections.get(indexPath.section);
        AdvancedTypeItem item = ObjectUtils.safeCast(section.get(indexPath.row), AdvancedTypeItem.class);
        if (item != null) {
            this.setSkinTypeWithItem(item);
        }
    }

    public static class AdvancedTypeItem
    extends UIComboItem {
        private final ISkinType skinType;

        public AdvancedTypeItem(UIImage icon, NSString name, ISkinType skinType) {
            super(icon, name);
            this.skinType = skinType;
        }

        public ISkinType getSkinType() {
            return this.skinType;
        }
    }

    public static class AdvancedTypeSection
    extends NewComboItem {
        private final String category;

        public AdvancedTypeSection(String category) {
            super(new NSString(category));
            this.category = category;
        }

        public AdvancedTypeItem add(ISkinType skinType) {
            ResourceLocation rl = ArmourersWorkshop.getItemIcon(skinType);
            UIImage icon = UIImage.of(rl).resize(12.0f, 12.0f, 16.0f, 16.0f).limit(16.0f, 16.0f).build();
            NSString name = new NSString((Component)TranslateUtils.Name.of(skinType));
            AdvancedTypeItem item = new AdvancedTypeItem(icon, name, skinType);
            this.add(item);
            return item;
        }
    }
}

