/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Arrays;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.IBlockEntityExtendedRenderer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TextureUtils;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundingBoxBlockEntity
extends UpdatableBlockEntity
implements IPaintable,
IBlockEntityExtendedRenderer {
    protected static final BlockPos INVALID = BlockPos.m_122022_((long)-1L);
    protected Vector3i guide = Vector3i.ZERO;
    protected BlockPos parent = INVALID;
    protected ISkinPartType partType = SkinPartTypes.UNKNOWN;
    private ArmourerBlockEntity cachedParentBlockEntity;
    private boolean customRenderer = false;

    public BoundingBoxBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.parent = OptionalAPI.getOptionalBlockPos(tag, "Refer", INVALID);
        this.guide = OptionalAPI.getOptionalVector3i(tag, "Offset", Vector3i.ZERO);
        this.partType = SkinPartTypes.byName(OptionalAPI.getOptionalString(tag, "PartType", SkinTypes.UNKNOWN.getRegistryName().toString()));
        this.customRenderer = Arrays.stream(Direction.values()).anyMatch(this::shouldChangeColor);
        this.cachedParentBlockEntity = null;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        OptionalAPI.putOptionalBlockPos(tag, "Refer", this.parent, INVALID);
        OptionalAPI.putOptionalVector3i(tag, "Offset", this.guide, Vector3i.ZERO);
        OptionalAPI.putOptionalString(tag, "PartType", this.partType.getRegistryName().toString(), SkinTypes.UNKNOWN.getRegistryName().toString());
    }

    public ISkinPartType getPartType() {
        return this.partType;
    }

    public void setPartType(ISkinPartType partType) {
        this.partType = partType;
    }

    public BlockPos getParent() {
        return this.parent;
    }

    public void setParent(BlockPos parent) {
        this.cachedParentBlockEntity = null;
        this.parent = parent;
    }

    public Vector3i getGuide() {
        return this.guide;
    }

    public void setGuide(Vector3i guide) {
        this.guide = guide;
    }

    public boolean isValid() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity != null && blockEntity.getSkinType() != null) {
            return blockEntity.getSkinType().getParts().contains(this.partType);
        }
        return false;
    }

    public boolean hasColors() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            IPaintColor paintColor = this.getArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir));
            if (paintColor == PaintColor.CLEAR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldChangeColor(Direction direction) {
        return this.getTexturePos(this.getParentBlockEntity(), direction) != null;
    }

    @Override
    public IPaintColor getColor(Direction direction) {
        TexturePos texturePos;
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        IPaintColor color = this.getArmourerTextureColor(blockEntity, texturePos = this.getTexturePos(blockEntity, direction));
        if (color != null && color.getPaintType() != SkinPaintTypes.NONE) {
            return color;
        }
        Level level = this.m_58904_();
        if (level != null && level.m_5776_()) {
            return this.getTextureColor(blockEntity, texturePos);
        }
        return PaintColor.CLEAR;
    }

    @Override
    public void setColor(Direction direction, IPaintColor color) {
    }

    @Override
    public void setColors(Map<Direction, IPaintColor> colors) {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        colors.forEach((dir, color) -> this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, (Direction)dir), (IPaintColor)color));
    }

    @Override
    public boolean hasColor(Direction direction) {
        return this.getColor(direction) != PaintColor.CLEAR;
    }

    public void clearArmourerTextureColors() {
        ArmourerBlockEntity blockEntity = this.getParentBlockEntity();
        if (blockEntity == null || this.m_58904_() == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir), PaintColor.CLEAR);
        }
    }

    public IPaintColor getArmourerTextureColor(ArmourerBlockEntity blockEntity, TexturePos texturePos) {
        IPaintColor color;
        if (texturePos != null && blockEntity != null && (color = blockEntity.getPaintColor(texturePos)) != null) {
            return color;
        }
        return PaintColor.CLEAR;
    }

    public void setArmourerTextureColor(ArmourerBlockEntity blockEntity, TexturePos texturePos, IPaintColor color) {
        if (texturePos != null && blockEntity != null) {
            blockEntity.setPaintColor(texturePos, color);
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private IPaintColor getTextureColor(ArmourerBlockEntity blockEntity, TexturePos texturePos) {
        IPaintColor color;
        if (texturePos != null && blockEntity != null && (color = TextureUtils.getPlayerTextureModelColor(blockEntity.getTextureDescriptor(), texturePos)) != null) {
            return color;
        }
        return PaintColor.CLEAR;
    }

    private TexturePos getTexturePos(ArmourerBlockEntity blockEntity, Direction direction) {
        return BoundingBox.getTexturePos(this.partType, this.guide, this.getResolvedDirection(blockEntity, direction));
    }

    private Direction getResolvedDirection(ArmourerBlockEntity blockEntity, Direction dir) {
        if (blockEntity == null) {
            return dir;
        }
        switch (blockEntity.getFacing()) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180.m_55954_(dir);
            }
            case WEST: {
                return Rotation.CLOCKWISE_90.m_55954_(dir);
            }
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90.m_55954_(dir);
            }
        }
        return dir;
    }

    private ArmourerBlockEntity getParentBlockEntity() {
        if (this.cachedParentBlockEntity != null) {
            if (this.cachedParentBlockEntity.m_58901_()) {
                return null;
            }
            return this.cachedParentBlockEntity;
        }
        Level level = this.m_58904_();
        if (level == null || this.parent.equals((Object)INVALID)) {
            return null;
        }
        BlockPos target = this.m_58899_().m_121996_((Vec3i)this.parent);
        ArmourerBlockEntity blockEntity = ObjectUtils.safeCast(level.m_7702_(target), ArmourerBlockEntity.class);
        if (blockEntity != null) {
            this.cachedParentBlockEntity = blockEntity;
            return this.cachedParentBlockEntity;
        }
        return null;
    }

    @Override
    public boolean shouldUseExtendedRenderer() {
        if (this.customRenderer) {
            return this.isValid();
        }
        return false;
    }
}

