/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;

public interface CGGraphicsState {
    public PoseStack ctm();

    public MultiBufferSource buffers();

    public UIFont font();

    public CGPoint mousePos();

    public float partialTicks();

    public void flush();

    default public void save() {
        this.ctm().m_85836_();
    }

    default public void translate(float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            this.ctm().m_85837_((double)x, (double)y, (double)z);
        }
    }

    default public void rotate(float x, float y, float z) {
        if (x != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.XP.rotationDegrees(x));
        }
        if (y != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.YP.rotationDegrees(y));
        }
        if (z != 0.0f) {
            ABI.mulPose(this.ctm(), Vector3f.ZP.rotationDegrees(z));
        }
    }

    default public void concatenate(CGAffineTransform transform) {
        PoseStack ctm = this.ctm();
        ABI.mulNormalMatrix(ctm, ObjectUtilsImpl.convertToMatrix3x3(transform));
        ABI.mulPoseMatrix(ctm, ObjectUtilsImpl.convertToMatrix4x4(transform));
    }

    default public void restore() {
        this.ctm().m_85849_();
    }
}

