/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.core.util.registry.BasicRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public final class BiomeUtil {
    private static final Set<ResourceKey<Biome>> CUSTOM_END_MUSIC_BIOMES = new HashSet<ResourceKey<Biome>>();
    private static final BasicRegistry<Codec<? extends ModdedBiomeProvider>> MODDED_PROVIDERS = new BasicRegistry();

    public static synchronized void registerBiomeProvider(ResourceLocation name, Codec<? extends ModdedBiomeProvider> codec) {
        MODDED_PROVIDERS.register(name, codec);
    }

    public static synchronized void markEndBiomeCustomMusic(ResourceKey<Biome> biomeName) {
        CUSTOM_END_MUSIC_BIOMES.add(biomeName);
    }

    public static boolean shouldPlayCustomEndMusic(ResourceKey<Biome> biomeName) {
        return CUSTOM_END_MUSIC_BIOMES.contains(biomeName);
    }

    public static int getId(@Nonnull ResourceKey<Biome> biome) {
        return BuiltinRegistries.f_123865_.m_7447_((Object)((Biome)BuiltinRegistries.f_123865_.m_6246_(biome)));
    }

    static {
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "original"), OriginalModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "multi_noise"), MultiNoiseModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "overlay"), OverlayModdedBiomeProvider.CODEC);
        MODDED_PROVIDERS.register(new ResourceLocation("blueprint", "biome_source"), BiomeSourceModdedBiomeProvider.CODEC);
    }

    public record OriginalModdedBiomeProvider() implements ModdedBiomeProvider
    {
        public static final Codec<OriginalModdedBiomeProvider> CODEC = Codec.unit((Object)new OriginalModdedBiomeProvider());

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return original.m_203407_(x, y, z, sampler);
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return new HashSet<Holder<Biome>>(0);
        }
    }

    public record MultiNoiseModdedBiomeProvider(Climate.ParameterList<ResourceKey<Biome>> biomes) implements ModdedBiomeProvider
    {
        public static final Codec<MultiNoiseModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_144637_((Codec)RecordCodecBuilder.create(pairInstance -> pairInstance.group((App)Climate.ParameterPoint.f_186862_.fieldOf("parameters").forGetter(Pair::getFirst), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122885_).fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)pairInstance, Pair::of)).listOf()).xmap(Climate.ParameterList::new, Climate.ParameterList::m_186850_).fieldOf("biomes").forGetter(sampler -> sampler.biomes)).apply((Applicative)instance, MultiNoiseModdedBiomeProvider::new));

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return registry.m_206081_((ResourceKey)this.biomes.m_204252_(sampler.m_183445_(x, y, z)));
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return this.biomes.m_186850_().stream().map(pair -> registry.m_206081_((ResourceKey)pair.getSecond())).collect(Collectors.toSet());
        }
    }

    public record OverlayModdedBiomeProvider(List<Pair<HolderSet<Biome>, BiomeSource>> overlays) implements ModdedBiomeProvider
    {
        public static final Codec<OverlayModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_).fieldOf("matches_biomes"), (MapCodec)BiomeSource.f_47888_.fieldOf("biome_source")).codec().listOf().fieldOf("overlays").forGetter(provider -> provider.overlays)).apply((Applicative)instance, OverlayModdedBiomeProvider::new));

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            Holder originalBiome = original.m_203407_(x, y, z, sampler);
            for (Pair<HolderSet<Biome>, BiomeSource> overlay : this.overlays) {
                if (!((HolderSet)overlay.getFirst()).m_203333_(originalBiome)) continue;
                return ((BiomeSource)overlay.getSecond()).m_203407_(x, y, z, sampler);
            }
            return originalBiome;
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            HashSet<Holder<Biome>> biomes = new HashSet<Holder<Biome>>();
            this.overlays.forEach(overlay -> biomes.addAll(((BiomeSource)overlay.getSecond()).m_207840_()));
            return biomes;
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }
    }

    public record BiomeSourceModdedBiomeProvider(BiomeSource biomeSource) implements ModdedBiomeProvider
    {
        public static final Codec<BiomeSourceModdedBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(provider -> provider.biomeSource)).apply((Applicative)instance, BiomeSourceModdedBiomeProvider::new));

        @Override
        public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler, BiomeSource original, Registry<Biome> registry) {
            return this.biomeSource.m_203407_(x, y, z, sampler);
        }

        @Override
        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> registry) {
            return this.biomeSource.m_207840_();
        }

        @Override
        public Codec<? extends ModdedBiomeProvider> codec() {
            return CODEC;
        }
    }

    public static interface ModdedBiomeProvider {
        public static final Codec<ModdedBiomeProvider> CODEC = MODDED_PROVIDERS.dispatchStable(ModdedBiomeProvider::codec, Function.identity());

        public Holder<Biome> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4, BiomeSource var5, Registry<Biome> var6);

        public Set<Holder<Biome>> getAdditionalPossibleBiomes(Registry<Biome> var1);

        public Codec<? extends ModdedBiomeProvider> codec();
    }
}

