/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GunpowderExplosion
extends Explosion {
    private float radius2;

    public GunpowderExplosion(Level world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, null, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.radius2 = size;
    }

    public void m_46061_() {
        int px = Mth.m_14107_((double)this.f_46013_);
        int py = Mth.m_14107_((double)this.f_46014_);
        int pz = Mth.m_14107_((double)this.f_46015_);
        this.radius2 *= 2.0f;
        ForgeHelper.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, new ArrayList(), (double)this.radius2);
        this.explodeBlock(px + 1, py, pz);
        this.explodeBlock(px - 1, py, pz);
        this.explodeBlock(px, py + 1, pz);
        this.explodeBlock(px, py - 1, pz);
        this.explodeBlock(px, py, pz + 1);
        this.explodeBlock(px, py, pz - 1);
        BlockPos pos = new BlockPos(px, py, pz);
        BlockState newFire = BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos);
        BlockState s = this.f_46012_.m_8055_(pos);
        if ((s.m_60767_().m_76336_() || s.m_60713_(ModRegistry.GUNPOWDER_BLOCK.get())) && (this.hasFlammableNeighbours(pos) || ForgeHelper.isFireSource((BlockState)this.f_46012_.m_8055_(pos.m_7495_()), (Level)this.f_46012_, (BlockPos)pos, (Direction)Direction.UP) || newFire.m_60734_() != Blocks.f_50083_)) {
            this.f_46012_.m_46597_(pos, newFire);
        }
    }

    private boolean hasFlammableNeighbours(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = this.f_46012_.m_8055_(pos.m_121945_(direction));
            if (!state.m_60767_().m_76335_() && (state.m_60734_() != ModRegistry.BELLOWS.get() || (Integer)state.m_61143_((Property)BellowsBlock.POWER) == 0 || state.m_61143_((Property)BellowsBlock.FACING) != direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private void explodeBlock(int i, int j, int k) {
        BlockPos pos = new BlockPos(i, j, k);
        FluidState fluidstate = this.f_46012_.m_6425_(pos);
        if (fluidstate.m_76152_() == Fluids.f_76191_) {
            BlockState state = this.f_46012_.m_8055_(pos);
            Block block = state.m_60734_();
            if (ForgeHelper.getExplosionResistance((BlockState)state, (Level)this.f_46012_, (BlockPos)pos, (Explosion)this) == 0.0f && block instanceof TntBlock) {
                this.getToBlow().add((Object)pos);
            }
            if (block instanceof ILightable) {
                ILightable lightable = (ILightable)block;
                lightable.lightUp(null, state, pos, (LevelAccessor)this.f_46012_, ILightable.FireSourceType.FLAMING_ARROW);
            } else if (state.m_204336_(BlockTags.f_13087_) && CampfireBlock.m_51321_((BlockState)state) || state.m_60734_() instanceof AbstractCandleBlock && !AbstractCandleBlock.m_151933_((BlockState)state) || CompatHandler.DECO_BLOCKS && DecoBlocksCompat.canLightBrazier(state)) {
                this.f_46012_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                ILightable.FireSourceType.FLAMING_ARROW.play((LevelAccessor)this.f_46012_, pos);
            }
        }
    }

    public ObjectArrayList<BlockPos> getToBlow() {
        return (ObjectArrayList)super.m_46081_();
    }

    public void m_46075_(boolean spawnFire) {
        BlockPos pos;
        ObjectArrayList drops = new ObjectArrayList();
        Util.m_214673_(this.getToBlow(), (RandomSource)this.f_46012_.f_46441_);
        for (BlockPos blockpos : this.getToBlow()) {
            Level level;
            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
            BlockPos immutable = blockpos.m_7949_();
            this.f_46012_.m_46473_().m_6180_("explosion_blocks");
            if (ForgeHelper.canDropFromExplosion((BlockState)blockstate, (Level)this.f_46012_, (BlockPos)blockpos, (Explosion)this) && (level = this.f_46012_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)blockEntity).m_78984_(LootContextParams.f_81455_, null);
                builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius2));
                blockstate.m_60724_(builder).forEach(d -> GunpowderExplosion.m_46067_((ObjectArrayList)drops, (ItemStack)d, (BlockPos)immutable));
            }
            ForgeHelper.onBlockExploded((BlockState)blockstate, (Level)this.f_46012_, (BlockPos)blockpos, (Explosion)this);
            this.f_46012_.m_46473_().m_7238_();
        }
        for (Pair pair : drops) {
            Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (spawnFire && this.f_46012_.m_8055_(pos = new BlockPos(this.f_46013_, this.f_46014_, this.f_46015_)).m_60795_() && this.f_46012_.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, pos.m_7495_())) {
            this.f_46012_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos));
        }
    }
}

