/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.datafixers.util.Pair;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.api.IExtendedItem;
import net.mehvahdjukaar.supplementaries.common.items.additional_placements.SimplePlacement;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerItem
extends BlockItem {
    protected static final Map<Block, Pair<Supplier<? extends Item>, Supplier<Boolean>>> PLACEABLE_ITEMS = new IdentityHashMap<Block, Pair<Supplier<? extends Item>, Supplier<Boolean>>>();
    private FoodProperties mimicFood;
    private Block mimicBlock;
    private SoundType overrideSound;

    public static void registerPlaceableItem(Block block, Supplier<? extends Item> item, Supplier<Boolean> config) {
        PLACEABLE_ITEMS.put(block, (Pair<Supplier<? extends Item>, Supplier<Boolean>>)Pair.of(item, config));
    }

    public BlockPlacerItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void m_6192_(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.m_6192_(pBlockToItemMap, pItem);
        for (Map.Entry<Block, Pair<Supplier<? extends Item>, Supplier<Boolean>>> v : PLACEABLE_ITEMS.entrySet()) {
            Block b = v.getKey();
            Item i = (Item)((Supplier)v.getValue().getFirst()).get();
            if (i == null || i == Items.f_41852_ || b == null || b == Blocks.f_50016_) continue;
            ((IExtendedItem)i).addAdditionalBehavior(new SimplePlacement(b));
            pBlockToItemMap.put(b, i);
        }
    }

    public boolean isDisabled(Block b) {
        Pair<Supplier<? extends Item>, Supplier<Boolean>> p = PLACEABLE_ITEMS.get(b);
        return p != null && (Boolean)((Supplier)p.getSecond()).get() == false;
    }

    @Nullable
    public BlockState mimicGetPlacementState(BlockPlaceContext pContext, Block toPlace) {
        if (this.isDisabled(toPlace)) {
            return null;
        }
        this.mimicBlock = toPlace;
        BlockState r = this.m_5965_(pContext);
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicUseOn(UseOnContext pContext, Block toPlace, FoodProperties foodProperties) {
        if (this.isDisabled(toPlace)) {
            return InteractionResult.PASS;
        }
        this.mimicFood = foodProperties;
        this.mimicBlock = toPlace;
        InteractionResult r = super.m_6225_(pContext);
        this.mimicFood = null;
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicPlace(BlockPlaceContext pContext, Block toPlace, @Nullable SoundType overrideSound) {
        if (this.isDisabled(toPlace)) {
            return InteractionResult.PASS;
        }
        this.overrideSound = overrideSound;
        this.mimicBlock = toPlace;
        InteractionResult r = super.m_40576_(pContext);
        this.overrideSound = null;
        this.mimicBlock = null;
        return r;
    }

    public Block m_40614_() {
        if (this.mimicBlock != null) {
            return this.mimicBlock;
        }
        return super.m_40614_();
    }

    @Nullable
    public FoodProperties m_41473_() {
        return this.mimicFood;
    }

    public boolean m_41472_() {
        return this.mimicFood != null;
    }

    protected SoundEvent m_40587_(BlockState pState) {
        if (this.overrideSound != null) {
            return this.overrideSound.m_56777_();
        }
        return super.m_40587_(pState);
    }

    public boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        this.mimicBlock = pState.m_60734_();
        boolean r = super.m_40610_(pContext, pState);
        this.mimicBlock = null;
        return r;
    }
}

