/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.AltarItemHandler;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAltar
extends BlockEntity {
    public static final BlockEntityType<TileEntityAltar> TYPE = BlockEntityType.Builder.m_155273_(TileEntityAltar::new, (Block[])new Block[]{(Block)InitBlocks.ALTAR.get()}).m_58966_(null);
    private static final String STORAGE_ITEM = "StorageItem";
    private static final String IS_RENDER = "IsRender";
    private static final String CAN_PLACE_ITEM = "CanPlaceItem";
    private static final String STORAGE_STATE_ID = "StorageBlockStateId";
    private static final String DIRECTION = "Direction";
    private static final String STORAGE_BLOCK_LIST = "StorageBlockList";
    private static final String CAN_PLACE_ITEM_POS_LIST = "CanPlaceItemPosList";
    public final ItemStackHandler handler = new AltarItemHandler();
    private boolean isRender = false;
    private boolean canPlaceItem = false;
    private BlockState storageState = Blocks.f_50016_.m_49966_();
    private PosListData blockPosList = new PosListData();
    private PosListData canPlaceItemPosList = new PosListData();
    private Direction direction = Direction.SOUTH;

    public TileEntityAltar(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(BlockState storageState, boolean isRender, boolean canPlaceItem, Direction direction, PosListData blockPosList, PosListData canPlaceItemPosList) {
        this.isRender = isRender;
        this.canPlaceItem = canPlaceItem;
        this.storageState = storageState;
        this.direction = direction;
        this.blockPosList = blockPosList;
        this.canPlaceItemPosList = canPlaceItemPosList;
        this.refresh();
    }

    public void m_183515_(CompoundTag compound) {
        this.getPersistentData().m_128379_(IS_RENDER, this.isRender);
        this.getPersistentData().m_128379_(CAN_PLACE_ITEM, this.canPlaceItem);
        this.getPersistentData().m_128405_(STORAGE_STATE_ID, Block.m_49956_((BlockState)this.storageState));
        this.getPersistentData().m_128365_(STORAGE_ITEM, (Tag)this.handler.serializeNBT());
        this.getPersistentData().m_128359_(DIRECTION, this.direction.m_7912_());
        this.getPersistentData().m_128365_(STORAGE_BLOCK_LIST, (Tag)this.blockPosList.serialize());
        this.getPersistentData().m_128365_(CAN_PLACE_ITEM_POS_LIST, (Tag)this.canPlaceItemPosList.serialize());
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isRender = this.getPersistentData().m_128471_(IS_RENDER);
        this.canPlaceItem = this.getPersistentData().m_128471_(CAN_PLACE_ITEM);
        this.storageState = Block.m_49803_((int)this.getPersistentData().m_128451_(STORAGE_STATE_ID));
        this.handler.deserializeNBT(this.getPersistentData().m_128469_(STORAGE_ITEM));
        this.direction = Direction.m_122402_((String)this.getPersistentData().m_128461_(DIRECTION));
        this.blockPosList.deserialize(this.getPersistentData().m_128437_(STORAGE_BLOCK_LIST, 10));
        this.canPlaceItemPosList.deserialize(this.getPersistentData().m_128437_(CAN_PLACE_ITEM_POS_LIST, 10));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-9, -5, -9), this.f_58858_.m_7918_(9, 5, 9));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public boolean isRender() {
        return this.isRender;
    }

    public boolean isCanPlaceItem() {
        return this.canPlaceItem;
    }

    public BlockState getStorageState() {
        return this.storageState;
    }

    public PosListData getBlockPosList() {
        return this.blockPosList;
    }

    public PosListData getCanPlaceItemPosList() {
        return this.canPlaceItemPosList;
    }

    public ItemStack getStorageItem() {
        if (this.canPlaceItem) {
            return this.handler.getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public Direction getDirection() {
        return this.direction;
    }
}

