/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetMaidSoundIdMessage {
    private final int entityId;
    private final String soundId;

    public SetMaidSoundIdMessage(int entityId, String soundId) {
        this.entityId = entityId;
        this.soundId = soundId;
    }

    public static void encode(SetMaidSoundIdMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130070_(message.soundId);
    }

    public static SetMaidSoundIdMessage decode(FriendlyByteBuf buf) {
        return new SetMaidSoundIdMessage(buf.readInt(), buf.m_130277_());
    }

    public static void handle(SetMaidSoundIdMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    maid.setSoundPackId(message.soundId);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

