/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ChessDataToServerMessage {
    private final BlockPos pos;
    private final Point point;

    public ChessDataToServerMessage(BlockPos pos, Point point) {
        this.pos = pos;
        this.point = point;
    }

    public static void encode(ChessDataToServerMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130130_(message.point.x);
        buf.m_130130_(message.point.y);
        buf.m_130130_(message.point.type);
    }

    public static ChessDataToServerMessage decode(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        Point pointIn = new Point(buf.m_130242_(), buf.m_130242_(), buf.m_130242_());
        return new ChessDataToServerMessage(blockPos, pointIn);
    }

    public static void handle(ChessDataToServerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Level level = sender.f_19853_;
                if (!level.m_46749_(message.pos)) {
                    return;
                }
                BlockEntity patt2359$temp = level.m_7702_(message.pos);
                if (patt2359$temp instanceof TileEntityGomoku) {
                    EntitySit sit;
                    Entity patt2848$temp;
                    ServerLevel serverLevel;
                    Entity patt2796$temp;
                    TileEntityGomoku gomoku = (TileEntityGomoku)patt2359$temp;
                    if (!gomoku.isInProgress() || gomoku.isPlayerTurn() || gomoku.getChessCounter() <= 0) {
                        return;
                    }
                    Point aiPoint = message.point;
                    gomoku.setChessData(aiPoint.x, aiPoint.y, aiPoint.type);
                    if (level instanceof ServerLevel && (patt2796$temp = (serverLevel = (ServerLevel)level).m_8791_(gomoku.getSitId())) instanceof EntitySit && (patt2848$temp = (sit = (EntitySit)patt2796$temp).m_146895_()) instanceof EntityMaid) {
                        EntityMaid maid = (EntityMaid)patt2848$temp;
                        maid.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    gomoku.setInProgress(MaidGomokuAI.getStatue(gomoku.getChessData(), aiPoint) == Statue.IN_PROGRESS);
                    level.m_5594_(null, message.pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                    if (gomoku.isInProgress()) {
                        gomoku.setPlayerTurn(true);
                    }
                    gomoku.refresh();
                }
            });
        }
        context.setPacketHandled(true);
    }
}

