/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMaidBeacon
extends DoubleHighBlockItem {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String STORAGE_DATA_TAG = "StorageData";
    private static final String FORGE_DATA_TAG = "ForgeData";
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemMaidBeacon() {
        super((Block)InitBlocks.MAID_BEACON.get(), new Item.Properties().m_41487_(1).m_41491_(MaidGroup.MAIN_TAB));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-3.2f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public static ItemStack tileEntityToItemStack(TileEntityMaidBeacon beacon) {
        ItemStack stack = ((Item)InitItems.MAID_BEACON.get()).m_7968_();
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128365_(STORAGE_DATA_TAG, (Tag)beacon.m_187482_());
        return stack;
    }

    public static void itemStackToTileEntity(ItemStack stack, TileEntityMaidBeacon beacon) {
        CompoundTag tag = stack.m_41698_(STORAGE_DATA_TAG);
        if (tag.m_128425_(FORGE_DATA_TAG, 10)) {
            beacon.loadData(tag.m_128469_(FORGE_DATA_TAG));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag forgeTag;
        float numPower = 0.0f;
        CompoundTag tag = stack.m_41698_(STORAGE_DATA_TAG);
        if (tag.m_128425_(FORGE_DATA_TAG, 10) && (forgeTag = tag.m_128469_(FORGE_DATA_TAG)).m_128425_("StoragePower", 5)) {
            numPower = forgeTag.m_128457_("StoragePower");
        }
        tooltip.add((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.maid_beacon.desc", (Object[])new Object[]{DECIMAL_FORMAT.format(numPower)}).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }
}

