/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.init.registry;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class MobSpawnInfoRegistry {
    private static MobSpawnSettings.SpawnerData SPAWNER_DATA;

    @SubscribeEvent
    public static void addMobSpawnInfo(LevelEvent.PotentialSpawns event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ResourceLocation dimension = level.m_46472_().m_135782_();
            Holder biome = level.m_204166_(event.getPos());
            if (MobSpawnInfoRegistry.dimensionIsOkay(dimension) && MobSpawnInfoRegistry.biomeIsOkay((Holder<Biome>)biome) && event.getMobCategory() == MobCategory.MONSTER) {
                List spawnerData = event.getSpawnerDataList();
                boolean canZombieSpawn = spawnerData.stream().anyMatch(data -> data.f_48404_.equals(EntityType.f_20501_));
                if (SPAWNER_DATA == null) {
                    SPAWNER_DATA = new MobSpawnSettings.SpawnerData((EntityType)InitEntities.FAIRY.get(), ((Integer)MiscConfig.MAID_FAIRY_SPAWN_PROBABILITY.get()).intValue(), 2, 4);
                }
                if (canZombieSpawn) {
                    event.addSpawnerData(SPAWNER_DATA);
                }
            }
        }
    }

    private static boolean dimensionIsOkay(ResourceLocation id) {
        return !((List)MiscConfig.MAID_FAIRY_BLACKLIST_DIMENSION.get()).contains(id.toString());
    }

    private static boolean biomeIsOkay(Holder<Biome> biome) {
        return ((List)MiscConfig.MAID_FAIRY_BLACKLIST_BIOME.get()).stream().noneMatch(name -> biome.m_203373_(new ResourceLocation(name)));
    }
}

