/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Bone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Cube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.ModelProperties;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.tree.RawBoneGroup;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.tree.RawGeometryTree;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.IGeoBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class GeoBuilder
implements IGeoBuilder {
    private static final Map<String, IGeoBuilder> MODDED_GEO_BUILDERS = new Object2ObjectOpenHashMap();
    private static final IGeoBuilder DEFAULT_BUILDER = new GeoBuilder();
    private static final String LEFT_HAND_LOCATOR = "LeftHandLocator";
    private static final String RIGHT_HAND_LOCATOR = "RightHandLocator";
    private static final String LEFT_WAIST_LOCATOR = "LeftWaistLocator";
    private static final String RIGHT_WAIST_LOCATOR = "RightWaistLocator";
    private static final String BACKPACK_LOCATOR_NAME = "BackpackLocator";
    private static final String HEAD_NAME = "Head";

    public static void registerGeoBuilder(String modid, IGeoBuilder builder) {
        MODDED_GEO_BUILDERS.put(modid, builder);
    }

    public static IGeoBuilder getGeoBuilder(String modid) {
        IGeoBuilder builder = MODDED_GEO_BUILDERS.get(modid);
        return builder == null ? DEFAULT_BUILDER : builder;
    }

    @Override
    public GeoModel constructGeoModel(RawGeometryTree geometryTree) {
        GeoModel model = new GeoModel();
        model.properties = geometryTree.properties;
        for (RawBoneGroup rawBone : geometryTree.topLevelBones.values()) {
            model.topLevelBones.add(this.constructBone(rawBone, geometryTree.properties, null));
        }
        model.getBone(LEFT_HAND_LOCATOR).ifPresent(b -> {
            this.getBoneParent((GeoBone)b, model.leftHandBones);
            Collections.reverse(model.leftHandBones);
        });
        model.getBone(RIGHT_HAND_LOCATOR).ifPresent(b -> {
            this.getBoneParent((GeoBone)b, model.rightHandBones);
            Collections.reverse(model.rightHandBones);
        });
        model.getBone(LEFT_WAIST_LOCATOR).ifPresent(b -> {
            this.getBoneParent((GeoBone)b, model.leftWaistBones);
            Collections.reverse(model.leftWaistBones);
        });
        model.getBone(RIGHT_WAIST_LOCATOR).ifPresent(b -> {
            this.getBoneParent((GeoBone)b, model.rightWaistBones);
            Collections.reverse(model.rightWaistBones);
        });
        model.getBone(BACKPACK_LOCATOR_NAME).ifPresent(b -> {
            this.getBoneParent((GeoBone)b, model.backpackBones);
            Collections.reverse(model.backpackBones);
        });
        model.getBone(HEAD_NAME).ifPresent(b -> {
            model.head = b;
            this.getBoneParent((GeoBone)b, model.headBones);
            Collections.reverse(model.headBones);
        });
        return model;
    }

    @Override
    public GeoBone constructBone(RawBoneGroup bone, ModelProperties properties, GeoBone parent) {
        GeoBone geoBone = new GeoBone();
        Bone rawBone = bone.selfBone;
        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(rawBone.getRotation()));
        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(rawBone.getPivot()));
        rotation.m_122263_(-1.0f, -1.0f, 1.0f);
        geoBone.mirror = rawBone.getMirror();
        geoBone.dontRender = rawBone.getNeverRender();
        geoBone.reset = rawBone.getReset();
        geoBone.inflate = rawBone.getInflate();
        geoBone.parent = parent;
        geoBone.setModelRendererName(rawBone.getName());
        geoBone.setRotationX((float)Math.toRadians(rotation.m_122239_()));
        geoBone.setRotationY((float)Math.toRadians(rotation.m_122260_()));
        geoBone.setRotationZ((float)Math.toRadians(rotation.m_122269_()));
        geoBone.rotationPointX = -pivot.m_122239_();
        geoBone.rotationPointY = pivot.m_122260_();
        geoBone.rotationPointZ = pivot.m_122269_();
        if (!ArrayUtils.isEmpty((Object[])rawBone.getCubes())) {
            for (Cube cube : rawBone.getCubes()) {
                geoBone.childCubes.add(GeoCube.createFromPojoCube(cube, properties, geoBone.inflate == null ? null : Double.valueOf(geoBone.inflate / 16.0), geoBone.mirror));
            }
        }
        for (RawBoneGroup child : bone.children.values()) {
            geoBone.childBones.add(this.constructBone(child, properties, geoBone));
        }
        return geoBone;
    }

    private void getBoneParent(GeoBone bone, List<GeoBone> boneList) {
        boneList.add(bone);
        if (bone.parent != null) {
            this.getBoneParent(bone.parent, boneList);
        }
    }
}

