/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public abstract class GeoReplacedEntityRenderer<T extends IAnimatable>
extends EntityRenderer
implements IGeoRenderer {
    protected static final Map<Class<? extends IAnimatable>, GeoReplacedEntityRenderer> renderers = new ConcurrentHashMap<Class<? extends IAnimatable>, GeoReplacedEntityRenderer>();
    protected final AnimatedGeoModel<IAnimatable> modelProvider;
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList();
    protected T animatable;
    protected IAnimatable currentAnimatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected MultiBufferSource rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        super(renderManager);
        this.modelProvider = modelProvider;
        this.animatable = animatable;
        renderers.putIfAbsent(animatable.getClass(), this);
    }

    public static GeoReplacedEntityRenderer getRenderer(Class<? extends IAnimatable> animatableClass) {
        return renderers.get(animatableClass);
    }

    public static int getPackedOverlay(LivingEntity entity, float u) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)u), (int)OverlayTexture.m_118096_((entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 1 : 0) != 0));
    }

    private static float getFacingAngle(Direction facingIn) {
        return switch (facingIn) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.m_109885_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.m_85982_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_85982_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    public float getWidthScale(Object animatable) {
        return this.widthScale;
    }

    public float getHeightScale(Object entity) {
        return this.heightScale;
    }

    public void renderEarly(Object animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = poseStack.m_85850_().m_85861_().m_27658_();
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void m_7392_(Entity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.render(entity, (IAnimatable)this.animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction direction;
        Entity entity2;
        Mob mob;
        Entity leashHolder;
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Replaced renderer was not an instanceof LivingEntity");
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        this.currentAnimatable = animatable;
        this.dispatchedMat = poseStack.m_85850_().m_85861_().m_27658_();
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        poseStack.m_85836_();
        if (entity instanceof Mob && (leashHolder = (mob = (Mob)entity).m_21524_()) != null) {
            this.renderLeash(mob, partialTick, poseStack, bufferSource, leashHolder);
        }
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = livingEntity.m_6162_();
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
        float lerpHeadRot = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (entity.m_20089_() == Pose.SLEEPING && (direction = livingEntity.m_21259_()) != null) {
            float eyeOffset = entity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_85837_((double)((float)(-direction.m_122429_()) * eyeOffset), 0.0, (double)((float)(-direction.m_122431_()) * eyeOffset));
        }
        float lerpedAge = (float)livingEntity.f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(livingEntity, poseStack, lerpedAge, lerpBodyRot, partialTick);
        this.preRenderCallback(livingEntity, poseStack, partialTick);
        if (!shouldSit && entity.m_6084_()) {
            limbSwingAmount = Math.min(1.0f, Mth.m_14179_((float)partialTick, (float)livingEntity.f_20923_, (float)livingEntity.f_20924_));
            limbSwing = livingEntity.f_20925_ - livingEntity.f_20924_ * (1.0f - partialTick);
            if (livingEntity.m_6162_()) {
                limbSwing *= 3.0f;
            }
        }
        float headPitch = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        AnimationEvent<IAnimatable> predicate = new AnimationEvent<IAnimatable>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount <= this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        this.modelProvider.setCustomAnimations(animatable, this.getInstanceId(entity), predicate);
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.m_5478_(entity));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight, this.m_5478_(entity));
        if (Minecraft.m_91087_().f_91074_ != null && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            VertexConsumer translucentBuffer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(animatable)));
            this.render(model, animatable, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, GeoReplacedEntityRenderer.getPackedOverlay(livingEntity, this.getOverlayProgress(livingEntity, partialTick)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            Entity entity = (Entity)this.animatable;
            Matrix4f poseState = poseStack.m_85850_().m_85861_().m_27658_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices(poseState, this.renderEarlyMat));
            localMatrix.m_27648_(new Vector3f(this.m_7860_(entity, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.m_27658_();
            worldState.m_27648_(new Vector3f(entity.m_20182_()));
            bone.setWorldSpaceXform(worldState);
        }
        IGeoRenderer.super.renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected float getOverlayProgress(LivingEntity entity, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entity, PoseStack poseStack, float partialTick) {
    }

    public ResourceLocation m_5478_(Entity entity) {
        return this.modelProvider.getTextureLocation(this.currentAnimatable);
    }

    @Override
    public AnimatedGeoModel getGeoModelProvider() {
        return this.modelProvider;
    }

    protected void applyRotations(LivingEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Pose pose = entity.m_20089_();
        if (pose != Pose.SLEEPING) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (pose == Pose.SLEEPING) {
            Direction bedOrientation = entity.m_21259_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(bedOrientation != null ? GeoReplacedEntityRenderer.getFacingAngle(bedOrientation) : rotationYaw));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation(entity)));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
            poseStack.m_85837_(0.0, -0.25, 0.0);
        } else if (entity.m_8077_() || entity instanceof Player) {
            String name = entity.m_7755_().getString();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.m_126649_((String)name);
            }
            if (name != null && ("Dinnerbone".equals(name) || "Grumm".equalsIgnoreCase(name))) {
                poseStack.m_85837_(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
        }
    }

    protected boolean isVisible(LivingEntity entity) {
        return !entity.m_20145_();
    }

    protected float getDeathMaxRotation(LivingEntity entity) {
        return 90.0f;
    }

    public boolean m_6512_(Entity entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.m_20163_() ? 32.0 : 64.0;
        if (this.f_114476_.m_114471_(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity.m_6052_() || entity == this.f_114476_.f_114359_ && entity.m_8077_() && Minecraft.m_91404_();
    }

    protected float getSwingProgress(LivingEntity entity, float partialTick) {
        return entity.m_21324_(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    public ResourceLocation getTextureLocation(Object animatable) {
        return this.modelProvider.getTextureLocation((IAnimatable)animatable);
    }

    public final boolean addLayer(GeoLayerRenderer<? extends LivingEntity> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(Mob entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.m_14179_((float)partialTick, (float)entity.f_20883_, (float)entity.f_20884_) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = entity.m_7939_();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.f_82481_ + Math.sin(lerpBodyAngle) * leashOffset.f_82479_;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.f_82481_ - Math.cos(lerpBodyAngle) * leashOffset.f_82479_;
        double lerpOriginX = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_()) + xAngleOffset;
        double lerpOriginY = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_()) + leashOffset.f_82480_;
        double lerpOriginZ = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.m_7398_(partialTick);
        float xDif = (float)(ropeGripPosition.f_82479_ - lerpOriginX);
        float yDif = (float)(ropeGripPosition.f_82480_ - lerpOriginY);
        float zDif = (float)(ropeGripPosition.f_82481_ - lerpOriginZ);
        float offsetMod = Mth.m_14195_((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        BlockPos entityEyePos = new BlockPos(entity.m_20299_(partialTick));
        BlockPos holderEyePos = new BlockPos(leashHolder.m_20299_(partialTick));
        int entityBlockLight = this.m_6086_((Entity)entity, entityEyePos);
        int holderBlockLight = leashHolder.m_6060_() ? 15 : leashHolder.f_19853_.m_45517_(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = entity.f_19853_.m_45517_(LightLayer.SKY, entityEyePos);
        int holderSkyLight = entity.f_19853_.m_45517_(LightLayer.SKY, holderEyePos);
        poseStack.m_85836_();
        poseStack.m_85837_(xAngleOffset, leashOffset.f_82480_, zAngleOffset);
        Matrix4f posMatrix = poseStack.m_85850_().m_85861_();
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.m_85849_();
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            GeoReplacedEntityRenderer renderer = renderers.get(object.getClass());
            return renderer == null ? null : renderer.getGeoModelProvider();
        });
    }
}

