/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatableModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.GeoModelProvider;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.AnimationUtils;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public abstract class GeoEntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected final List<GeoLayerRenderer<T>> layerRenderers = new ObjectArrayList();
    public ItemStack mainHand;
    public ItemStack offHand;
    public ItemStack helmet;
    public ItemStack chestplate;
    public ItemStack leggings;
    public ItemStack boots;
    public MultiBufferSource rtb;
    public ResourceLocation whTexture;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected T animatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    private static float getFacingAngle(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.m_109885_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.m_85982_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_85982_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public void renderEarly(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        this.animatable = animatable;
        this.renderEarlyMat = poseStack.m_85850_().m_85861_().m_27658_();
        this.rtb = bufferSource;
        this.whTexture = this.getTextureLocation(animatable);
        this.mainHand = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offHand = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmet = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplate = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggings = animatable.m_6844_(EquipmentSlot.LEGS);
        this.boots = animatable.m_6844_(EquipmentSlot.FEET);
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
    }

    public void render(T animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction bedDirection;
        Entity entity;
        Mob mob;
        Entity leashHolder;
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        poseStack.m_85836_();
        if (animatable instanceof Mob && (leashHolder = (mob = (Mob)animatable).m_21524_()) != null) {
            this.renderLeash(animatable, partialTick, poseStack, bufferSource, leashHolder);
        }
        this.dispatchedMat = poseStack.m_85850_().m_85861_().m_27658_();
        boolean shouldSit = animatable.m_20159_() && animatable.m_20202_() != null && animatable.m_20202_().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = animatable.m_6162_();
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)((LivingEntity)animatable).f_20884_, (float)((LivingEntity)animatable).f_20883_);
        float lerpHeadRot = Mth.m_14189_((float)partialTick, (float)((LivingEntity)animatable).f_20886_, (float)((LivingEntity)animatable).f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity = animatable.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.m_20089_() == Pose.SLEEPING && (bedDirection = animatable.m_21259_()) != null) {
            float eyePosOffset = animatable.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_85837_((double)((float)(-bedDirection.m_122429_()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.m_122431_()) * eyePosOffset));
        }
        float ageInTicks = (float)((LivingEntity)animatable).f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && animatable.m_6084_()) {
            limbSwingAmount = Mth.m_14179_((float)partialTick, (float)((LivingEntity)animatable).f_20923_, (float)((LivingEntity)animatable).f_20924_);
            limbSwing = ((LivingEntity)animatable).f_20925_ - ((LivingEntity)animatable).f_20924_ * (1.0f - partialTick);
            if (animatable.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = Mth.m_14179_((float)partialTick, (float)((LivingEntity)animatable).f_19860_, (float)animatable.m_146909_());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<T> predicate = new AnimationEvent<T>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount > this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        this.modelProvider.setCustomAnimations(animatable, this.getInstanceId(animatable), (AnimationEvent)predicate);
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(animatable));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(animatable));
        if (Minecraft.m_91087_().f_91074_ != null && !animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            VertexConsumer translucentBuffer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation(animatable)));
            this.render(model, animatable, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, this.getOverlay(animatable, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!animatable.m_5833_()) {
            for (GeoLayerRenderer<T> layerRenderer : this.layerRenderers) {
                this.renderLayer(poseStack, bufferSource, packedLight, animatable, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch, bufferSource, layerRenderer);
            }
        }
        poseStack.m_85849_();
        super.m_7392_(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean rotOverride;
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        boolean bl = rotOverride = bone.rotMat != null;
        if (rotOverride) {
            poseStack.m_85850_().m_85861_().m_27644_(bone.rotMat);
            poseStack.m_85850_().m_85864_().m_8178_(new Matrix3f(bone.rotMat));
        } else {
            RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        }
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingXform()) {
            Matrix4f poseState = poseStack.m_85850_().m_85861_().m_27658_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices(poseState, this.renderEarlyMat));
            localMatrix.m_27648_(new Vector3f(this.m_7860_((Entity)this.animatable, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.m_27658_();
            worldState.m_27648_(new Vector3f(this.animatable.m_20182_()));
            bone.setWorldSpaceXform(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!bone.isHidden) {
            if (!bone.cubesAreHidden()) {
                for (GeoCube geoCube : bone.childCubes) {
                    poseStack.m_85836_();
                    this.renderCube(geoCube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    poseStack.m_85849_();
                }
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    protected void renderLayer(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T animatable, float limbSwing, float limbSwingAmount, float partialTick, float rotFloat, float netHeadYaw, float headPitch, MultiBufferSource bufferSource2, GeoLayerRenderer<T> layerRenderer) {
        layerRenderer.render(poseStack, bufferSource, packedLight, animatable, limbSwing, limbSwingAmount, partialTick, rotFloat, netHeadYaw, headPitch);
    }

    @Override
    public int getInstanceId(T animatable) {
        return animatable.m_19879_();
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    public int getOverlay(T entity, float u) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)u), (int)OverlayTexture.m_118096_((((LivingEntity)entity).f_20916_ > 0 || ((LivingEntity)entity).f_20919_ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Pose pose = animatable.m_20089_();
        if (pose != Pose.SLEEPING) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (((LivingEntity)animatable).f_20919_ > 0) {
            float deathRotation = ((float)((LivingEntity)animatable).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (animatable.m_21209_()) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - animatable.m_146909_()));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)((LivingEntity)animatable).f_19797_ + partialTick) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction bedOrientation = animatable.m_21259_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(bedOrientation != null ? GeoEntityRenderer.getFacingAngle(bedOrientation) : rotationYaw));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(this.getDeathMaxRotation(animatable)));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if (animatable.m_8077_() || animatable instanceof Player) {
            String name = animatable.m_7755_().getString();
            if (animatable instanceof Player) {
                Player player = (Player)animatable;
                if (!player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.m_126649_((String)name);
            }
            if (name != null && ("Dinnerbone".equals(name) || "Grumm".equalsIgnoreCase(name))) {
                poseStack.m_85837_(0.0, (double)(animatable.m_20206_() + 0.1f), 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
        }
    }

    protected boolean isVisible(T animatable) {
        return !animatable.m_20145_();
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public boolean shouldShowName(T animatable) {
        double nameRenderDistance;
        double d = nameRenderDistance = animatable.m_20163_() ? 32.0 : 64.0;
        if (this.f_114476_.m_114471_(animatable) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return animatable == this.f_114476_.f_114359_ && animatable.m_8077_() && Minecraft.m_91404_();
    }

    protected float getSwingProgress(T animatable, float partialTick) {
        return animatable.m_21324_(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    @Override
    public ResourceLocation getTextureLocation(T animatable) {
        return this.modelProvider.getTextureLocation(animatable);
    }

    public final boolean addLayer(GeoLayerRenderer<T> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(T entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.m_14179_((float)partialTick, (float)((LivingEntity)entity).f_20883_, (float)((LivingEntity)entity).f_20884_) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = entity.m_7939_();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.f_82481_ + Math.sin(lerpBodyAngle) * leashOffset.f_82479_;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.f_82481_ - Math.cos(lerpBodyAngle) * leashOffset.f_82479_;
        double lerpOriginX = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19854_, (double)entity.m_20185_()) + xAngleOffset;
        double lerpOriginY = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19855_, (double)entity.m_20186_()) + leashOffset.f_82480_;
        double lerpOriginZ = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19856_, (double)entity.m_20189_()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.m_7398_(partialTick);
        float xDif = (float)(ropeGripPosition.f_82479_ - lerpOriginX);
        float yDif = (float)(ropeGripPosition.f_82480_ - lerpOriginY);
        float zDif = (float)(ropeGripPosition.f_82481_ - lerpOriginZ);
        float offsetMod = Mth.m_14195_((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        BlockPos entityEyePos = new BlockPos(entity.m_20299_(partialTick));
        BlockPos holderEyePos = new BlockPos(leashHolder.m_20299_(partialTick));
        int entityBlockLight = this.m_6086_((Entity)entity, entityEyePos);
        int holderBlockLight = leashHolder.m_6060_() ? 15 : leashHolder.f_19853_.m_45517_(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = ((LivingEntity)entity).f_19853_.m_45517_(LightLayer.SKY, entityEyePos);
        int holderSkyLight = ((LivingEntity)entity).f_19853_.m_45517_(LightLayer.SKY, holderEyePos);
        poseStack.m_85836_();
        poseStack.m_85837_(xAngleOffset, leashOffset.f_82480_, zAngleOffset);
        Matrix4f posMatrix = poseStack.m_85850_().m_85861_();
        for (segment = 0; segment <= 24; ++segment) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.m_85849_();
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    static {
        AnimationController.addModelFetcher(animatable -> {
            IAnimatableModel iAnimatableModel;
            if (animatable instanceof Entity) {
                Entity entity = (Entity)animatable;
                iAnimatableModel = (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity(entity));
            } else {
                iAnimatableModel = null;
            }
            return iAnimatableModel;
        });
    }
}

