/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatableModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.AnimationPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimationQueue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.IBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.PointData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.DirtyTracker;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.MathUtil;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationProcessor<T extends IAnimatable> {
    private final List<IBone> modelRendererList = new ObjectArrayList();
    private final IntSet animatedEntities = new IntOpenHashSet();
    private final IAnimatableModel animatedModel;
    public boolean reloadAnimations = false;
    private double lastTickValue = -1.0;

    public AnimationProcessor(IAnimatableModel animatedModel) {
        this.animatedModel = animatedModel;
    }

    public void tickAnimation(IAnimatable entity, int uniqueID, double seekTime, AnimationEvent<T> event, MolangParser parser, boolean crashWhenCantFindBone) {
        if (seekTime != this.lastTickValue) {
            this.animatedEntities.clear();
        } else if (this.animatedEntities.contains(uniqueID)) {
            return;
        }
        this.lastTickValue = seekTime;
        this.animatedEntities.add(uniqueID);
        AnimationData manager = entity.getFactory().getOrCreateAnimationData(uniqueID);
        Map<String, DirtyTracker> modelTracker = this.createNewDirtyTracker();
        this.updateBoneSnapshots(manager.getBoneSnapshotCollection());
        Map<String, Pair<IBone, BoneSnapshot>> boneSnapshots = manager.getBoneSnapshotCollection();
        HashMap pointDataGroup = Maps.newHashMap();
        for (AnimationController controller : manager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.markNeedsReload();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = manager.isFirstTick;
            event.setController(controller);
            controller.process(seekTime, event, this.modelRendererList, boneSnapshots, parser, crashWhenCantFindBone);
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                IBone bone = boneAnimation.bone();
                BoneSnapshot snapshot = (BoneSnapshot)boneSnapshots.get(bone.getName()).getRight();
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                pointDataGroup.putIfAbsent(bone.getName(), new PointData());
                PointData pointData = (PointData)pointDataGroup.get(bone.getName());
                AnimationPoint rXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint pXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint pYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint pZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint sXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint sYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint sZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                DirtyTracker dirtyTracker = modelTracker.get(bone.getName());
                if (dirtyTracker == null) continue;
                if (rXPoint != null && rYPoint != null && rZPoint != null) {
                    float valueX = MathUtil.lerpValues(rXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    float valueY = MathUtil.lerpValues(rYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    float valueZ = MathUtil.lerpValues(rZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod);
                    pointData.rotationValueX += valueX;
                    pointData.rotationValueY += valueY;
                    pointData.rotationValueZ += valueZ;
                    if (controller.getName().startsWith("parallel_")) {
                        bone.setRotationX(pointData.rotationValueX + initialSnapshot.rotationValueX);
                        bone.setRotationY(pointData.rotationValueY + initialSnapshot.rotationValueY);
                        bone.setRotationZ(pointData.rotationValueZ + initialSnapshot.rotationValueZ);
                    } else {
                        bone.setRotationX(valueX + initialSnapshot.rotationValueX);
                        bone.setRotationY(valueY + initialSnapshot.rotationValueY);
                        bone.setRotationZ(valueZ + initialSnapshot.rotationValueZ);
                    }
                    snapshot.rotationValueX = bone.getRotationX();
                    snapshot.rotationValueY = bone.getRotationY();
                    snapshot.rotationValueZ = bone.getRotationZ();
                    snapshot.isCurrentlyRunningRotationAnimation = true;
                    dirtyTracker.hasRotationChanged = true;
                }
                if (pXPoint != null && pYPoint != null && pZPoint != null) {
                    bone.setPositionX(MathUtil.lerpValues(pXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                    bone.setPositionY(MathUtil.lerpValues(pYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                    bone.setPositionZ(MathUtil.lerpValues(pZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                    snapshot.positionOffsetX = bone.getPositionX();
                    snapshot.positionOffsetY = bone.getPositionY();
                    snapshot.positionOffsetZ = bone.getPositionZ();
                    snapshot.isCurrentlyRunningPositionAnimation = true;
                    dirtyTracker.hasPositionChanged = true;
                }
                if (sXPoint == null || sYPoint == null || sZPoint == null) continue;
                bone.setScaleX(MathUtil.lerpValues(sXPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                bone.setScaleY(MathUtil.lerpValues(sYPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                bone.setScaleZ(MathUtil.lerpValues(sZPoint, controller.easingType, (Function<Double, Double>)controller.customEasingMethod));
                snapshot.scaleValueX = bone.getScaleX();
                snapshot.scaleValueY = bone.getScaleY();
                snapshot.scaleValueZ = bone.getScaleZ();
                snapshot.isCurrentlyRunningScaleAnimation = true;
                dirtyTracker.hasScaleChanged = true;
            }
        }
        this.reloadAnimations = false;
        double resetTickLength = manager.getResetSpeed();
        for (Map.Entry<String, DirtyTracker> tracker : modelTracker.entrySet()) {
            double percentageReset;
            IBone model = tracker.getValue().model;
            BoneSnapshot initialSnapshot = model.getInitialSnapshot();
            BoneSnapshot saveSnapshot = (BoneSnapshot)boneSnapshots.get(tracker.getKey()).getRight();
            if (saveSnapshot == null) {
                if (!crashWhenCantFindBone) continue;
                throw new RuntimeException("Could not find save snapshot for bone: " + tracker.getValue().model.getName() + ". Please don't add bones that are used in an animation at runtime.");
            }
            if (!tracker.getValue().hasRotationChanged) {
                if (saveSnapshot.isCurrentlyRunningRotationAnimation) {
                    saveSnapshot.mostRecentResetRotationTick = 0.0f;
                    saveSnapshot.isCurrentlyRunningRotationAnimation = false;
                }
                percentageReset = Math.min((seekTime - (double)saveSnapshot.mostRecentResetRotationTick) / resetTickLength, 1.0);
                model.setRotationX(MathUtil.lerpValues(percentageReset, saveSnapshot.rotationValueX, initialSnapshot.rotationValueX));
                model.setRotationY(MathUtil.lerpValues(percentageReset, saveSnapshot.rotationValueY, initialSnapshot.rotationValueY));
                model.setRotationZ(MathUtil.lerpValues(percentageReset, saveSnapshot.rotationValueZ, initialSnapshot.rotationValueZ));
                if (percentageReset >= 1.0) {
                    saveSnapshot.rotationValueX = model.getRotationX();
                    saveSnapshot.rotationValueY = model.getRotationY();
                    saveSnapshot.rotationValueZ = model.getRotationZ();
                }
            }
            if (!tracker.getValue().hasPositionChanged) {
                if (saveSnapshot.isCurrentlyRunningPositionAnimation) {
                    saveSnapshot.mostRecentResetPositionTick = (float)seekTime;
                    saveSnapshot.isCurrentlyRunningPositionAnimation = false;
                }
                percentageReset = Math.min((seekTime - (double)saveSnapshot.mostRecentResetPositionTick) / resetTickLength, 1.0);
                model.setPositionX(MathUtil.lerpValues(percentageReset, saveSnapshot.positionOffsetX, initialSnapshot.positionOffsetX));
                model.setPositionY(MathUtil.lerpValues(percentageReset, saveSnapshot.positionOffsetY, initialSnapshot.positionOffsetY));
                model.setPositionZ(MathUtil.lerpValues(percentageReset, saveSnapshot.positionOffsetZ, initialSnapshot.positionOffsetZ));
                if (percentageReset >= 1.0) {
                    saveSnapshot.positionOffsetX = model.getPositionX();
                    saveSnapshot.positionOffsetY = model.getPositionY();
                    saveSnapshot.positionOffsetZ = model.getPositionZ();
                }
            }
            if (tracker.getValue().hasScaleChanged) continue;
            if (saveSnapshot.isCurrentlyRunningScaleAnimation) {
                saveSnapshot.mostRecentResetScaleTick = (float)seekTime;
                saveSnapshot.isCurrentlyRunningScaleAnimation = false;
            }
            percentageReset = Math.min((seekTime - (double)saveSnapshot.mostRecentResetScaleTick) / resetTickLength, 1.0);
            model.setScaleX(MathUtil.lerpValues(percentageReset, saveSnapshot.scaleValueX, initialSnapshot.scaleValueX));
            model.setScaleY(MathUtil.lerpValues(percentageReset, saveSnapshot.scaleValueY, initialSnapshot.scaleValueY));
            model.setScaleZ(MathUtil.lerpValues(percentageReset, saveSnapshot.scaleValueZ, initialSnapshot.scaleValueZ));
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.scaleValueX = model.getScaleX();
            saveSnapshot.scaleValueY = model.getScaleY();
            saveSnapshot.scaleValueZ = model.getScaleZ();
        }
        manager.isFirstTick = false;
    }

    private Map<String, DirtyTracker> createNewDirtyTracker() {
        Object2ObjectOpenHashMap tracker = new Object2ObjectOpenHashMap();
        for (IBone bone : this.modelRendererList) {
            tracker.put(bone.getName(), new DirtyTracker(false, false, false, bone));
        }
        return tracker;
    }

    private void updateBoneSnapshots(Map<String, Pair<IBone, BoneSnapshot>> boneSnapshotCollection) {
        for (IBone bone : this.modelRendererList) {
            if (boneSnapshotCollection.containsKey(bone.getName())) continue;
            boneSnapshotCollection.put(bone.getName(), (Pair<IBone, BoneSnapshot>)Pair.of((Object)bone, (Object)new BoneSnapshot(bone.getInitialSnapshot())));
        }
    }

    public IBone getBone(String boneName) {
        for (IBone bone : this.modelRendererList) {
            if (!bone.getName().equals(boneName)) continue;
            return bone;
        }
        return null;
    }

    public void registerModelRenderer(IBone modelRenderer) {
        modelRenderer.saveInitialSnapshot();
        this.modelRendererList.add(modelRenderer);
    }

    public void clearModelRendererList() {
        this.modelRendererList.clear();
    }

    public List<IBone> getModelRendererList() {
        return this.modelRendererList;
    }

    public void preAnimationSetup(IAnimatable animatable, double seekTime) {
        this.animatedModel.setMolangQueries(animatable, seekTime);
    }
}

