/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.KeyFrame;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class VectorKeyFrameList<T extends KeyFrame> {
    public List<T> xKeyFrames;
    public List<T> yKeyFrames;
    public List<T> zKeyFrames;

    public VectorKeyFrameList(List<T> XKeyFrames, List<T> YKeyFrames, List<T> ZKeyFrames) {
        this.xKeyFrames = XKeyFrames;
        this.yKeyFrames = YKeyFrames;
        this.zKeyFrames = ZKeyFrames;
    }

    public VectorKeyFrameList() {
        this.xKeyFrames = new ObjectArrayList();
        this.yKeyFrames = new ObjectArrayList();
        this.zKeyFrames = new ObjectArrayList();
    }

    public double getLastKeyframeTime() {
        double xTime = 0.0;
        for (KeyFrame frame : this.xKeyFrames) {
            xTime += frame.getLength().doubleValue();
        }
        double yTime = 0.0;
        for (KeyFrame frame : this.yKeyFrames) {
            yTime += frame.getLength().doubleValue();
        }
        double zTime = 0.0;
        for (KeyFrame frame : this.zKeyFrames) {
            zTime += frame.getLength().doubleValue();
        }
        return Math.max(xTime, Math.max(yTime, zTime));
    }
}

