/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task.meal;

import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.event.MaidMealRegConfigEvent;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class DefaultMaidHealSelfMeal
implements IMaidMeal {
    private static final int MAX_PROBABILITY = 5;

    @Override
    public boolean canMaidEat(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        return stack.m_41614_() && !IMaidMeal.isBlockList(stack, (List)MaidConfig.MAID_HEAL_MEALS_BLOCK_LIST.get()) && !IMaidMeal.isBlockList(stack, MaidMealRegConfigEvent.HEAL_MEAL_REGEX);
    }

    @Override
    public void onMaidEat(EntityMaid maid, ItemStack stack, InteractionHand hand) {
        FoodProperties foodProperties = stack.getFoodProperties((LivingEntity)maid);
        if (foodProperties != null) {
            maid.m_6672_(hand);
            int nutrition = foodProperties.m_38744_();
            float saturationModifier = foodProperties.m_38745_();
            float total = (float)nutrition + (float)nutrition * saturationModifier * 2.0f;
            if ((float)maid.m_217043_().m_188503_(5) < total) {
                float healCount = Math.max(total / 5.0f, 1.0f);
                maid.m_5634_(healCount);
                NetworkHandler.sendToNearby((Entity)maid, new SpawnParticleMessage(maid.m_19879_(), SpawnParticleMessage.Type.HEAL, stack.m_41779_()));
            }
        }
    }
}

