/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSnowballTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidStartSnowballAttacking;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class TaskIdle
implements IMaidTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "idle");
    private static final float LOW_TEMPERATURE = 0.15f;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42402_.m_7968_();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Behavior<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        Pair findSnowballTarget = Pair.of((Object)6, new MaidStartSnowballAttacking<EntityMaid>(this::canSnowballFight, this::findFirstValidSnowballTarget));
        Pair snowballFight = Pair.of((Object)7, (Object)((Object)new MaidSnowballTargetTask(40)));
        return Lists.newArrayList((Object[])new Pair[]{findSnowballTarget, snowballFight});
    }

    private boolean canSnowballFight(EntityMaid maid) {
        Level world = maid.f_19853_;
        BlockPos pos = maid.m_20183_();
        return !maid.isBegging() && ((Biome)world.m_204166_(pos).m_203334_()).m_198904_(pos) && world.m_8055_(pos).m_60713_(Blocks.f_50125_);
    }

    private Optional<? extends LivingEntity> findFirstValidSnowballTarget(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(list -> list.m_186128_(e -> this.isSnowballTarget((LivingEntity)e, maid)).filter(e -> maid.m_21444_(e.m_20183_())).findFirst());
    }

    private boolean isSnowballTarget(LivingEntity entity, EntityMaid maid) {
        if (maid.m_21830_(entity)) {
            return true;
        }
        if (entity instanceof EntityMaid && maid.m_21826_() != null) {
            EntityMaid maidOther = (EntityMaid)entity;
            return maid.m_21826_().equals((Object)maidOther.m_21826_());
        }
        return false;
    }
}

