/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import java.util.Random;

public enum DanmakuColor {
    RED(0xFF0000),
    ORANGE(0xFF7F00),
    YELLOW(0xFEFF00),
    LIME(0x7FFF00),
    LIGHT_GREEN(65280),
    GREEN(65407),
    CYAN(1965823),
    LIGHT_BLUE(Short.MAX_VALUE),
    BLUE(255),
    PURPLE(0x7F00FF),
    MAGENTA(0xFF00FE),
    PINK(0xFF007F),
    GRAY(0x8C8C8C);

    private final int rgb;
    private final int red;
    private final int green;
    private final int blue;
    private final int floatRed;
    private final int floatGreen;
    private final int floatBlue;

    private DanmakuColor(int color) {
        this.rgb = color;
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        this.floatRed = this.red / 255;
        this.floatGreen = this.green / 255;
        this.floatBlue = this.blue / 255;
    }

    public static DanmakuColor getColor(int index) {
        if (index < 0 || index >= DanmakuColor.values().length) {
            return RED;
        }
        return DanmakuColor.values()[index];
    }

    public static DanmakuColor random(Random random) {
        return DanmakuColor.getColor(random.nextInt(DanmakuColor.getLength()));
    }

    public static int getLength() {
        return DanmakuColor.values().length;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getFloatRed() {
        return this.floatRed;
    }

    public int getFloatGreen() {
        return this.floatGreen;
    }

    public int getFloatBlue() {
        return this.floatBlue;
    }

    public int getRgb() {
        return this.rgb;
    }
}

