/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityExtinguishingAgent
extends Entity {
    public static final EntityType<EntityExtinguishingAgent> TYPE = EntityType.Builder.m_20704_(EntityExtinguishingAgent::new, (MobCategory)MobCategory.MISC).m_20699_(0.2f, 0.2f).m_20702_(10).m_20712_("extinguishing_agent");
    private static final int MAX_AGE = 60;
    private static final int REMOVE_FIRE_AGE = 5;
    private List<Monster> cacheFireImmuneMonster = Lists.newArrayList();

    public EntityExtinguishingAgent(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityExtinguishingAgent(Level worldIn, Vec3 position) {
        this(TYPE, worldIn);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19797_ > 60) {
            this.m_146870_();
            return;
        }
        if (this.f_19797_ == 5) {
            this.removeBlockFire();
            this.removeEntityFire();
        }
        this.damageFireImmuneMonster();
        if (this.f_19853_.f_46443_) {
            this.spawnCloudParticle();
        }
        this.m_5496_(SoundEvents.f_12642_, 2.0f - 0.03f * (float)this.f_19797_, 0.1f);
    }

    private void spawnCloudParticle() {
        int spawnNumber = 4;
        for (int i = 0; i < spawnNumber; ++i) {
            double offsetX = 2.0 * this.f_19796_.m_188500_() - 1.0;
            double offsetY = this.f_19796_.m_188500_() / 2.0;
            double offsetZ = 2.0 * this.f_19796_.m_188500_() - 1.0;
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void damageFireImmuneMonster() {
        if (this.f_19797_ % 5 == 0 && this.cacheFireImmuneMonster != null && !this.cacheFireImmuneMonster.isEmpty()) {
            this.cacheFireImmuneMonster.forEach(monster -> {
                if (monster.m_6084_()) {
                    monster.m_6469_(DamageSource.f_19319_, 2.0f);
                }
            });
        }
    }

    private void removeEntityFire() {
        List list = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(2.0, 1.0, 2.0));
        this.cacheFireImmuneMonster = this.f_19853_.m_6443_(Monster.class, this.m_20191_().m_82377_(2.0, 1.0, 2.0), Entity::m_5825_);
        for (LivingEntity entity : list) {
            entity.m_20095_();
        }
    }

    private void removeBlockFire() {
        int hRange = 2;
        int vRange = 1;
        for (int x = -hRange; x <= hRange; ++x) {
            for (int y = -vRange; y <= vRange; ++y) {
                for (int z = -hRange; z <= hRange; ++z) {
                    BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                    BlockState state = this.f_19853_.m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_50083_)) continue;
                    this.f_19853_.m_7471_(pos, false);
                }
            }
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

