/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import org.apache.commons.lang3.tuple.Pair;

public class MaidChatBubbles {
    public static final Pair<Long, ChatText> EMPTY = Pair.of((Object)-1L, (Object)ChatText.EMPTY_CHAT_TEXT);
    public static final MaidChatBubbles DEFAULT = new MaidChatBubbles(EMPTY, EMPTY, EMPTY);
    public static final EntityDataSerializer<MaidChatBubbles> DATA = new EntityDataSerializer<MaidChatBubbles>(){

        public void write(FriendlyByteBuf buf, MaidChatBubbles value) {
            buf.writeLong(((Long)value.getBubble1().getLeft()).longValue());
            ChatText.toBuff((ChatText)value.getBubble1().getRight(), buf);
            buf.writeLong(((Long)value.getBubble2().getLeft()).longValue());
            ChatText.toBuff((ChatText)value.getBubble2().getRight(), buf);
            buf.writeLong(((Long)value.getBubble3().getLeft()).longValue());
            ChatText.toBuff((ChatText)value.getBubble3().getRight(), buf);
        }

        public MaidChatBubbles read(FriendlyByteBuf buf) {
            Pair bubble1 = Pair.of((Object)buf.readLong(), (Object)ChatText.fromBuff(buf));
            Pair bubble2 = Pair.of((Object)buf.readLong(), (Object)ChatText.fromBuff(buf));
            Pair bubble3 = Pair.of((Object)buf.readLong(), (Object)ChatText.fromBuff(buf));
            return new MaidChatBubbles((Pair<Long, ChatText>)bubble1, (Pair<Long, ChatText>)bubble2, (Pair<Long, ChatText>)bubble3);
        }

        public MaidChatBubbles copy(MaidChatBubbles value) {
            return value;
        }
    };
    private final Pair<Long, ChatText> bubble1;
    private final Pair<Long, ChatText> bubble2;
    private final Pair<Long, ChatText> bubble3;

    public MaidChatBubbles(Pair<Long, ChatText> bubble1, Pair<Long, ChatText> bubble2, Pair<Long, ChatText> bubble3) {
        this.bubble1 = bubble1;
        this.bubble2 = bubble2;
        this.bubble3 = bubble3;
    }

    public Pair<Long, ChatText> getBubble1() {
        return this.bubble1;
    }

    public Pair<Long, ChatText> getBubble2() {
        return this.bubble2;
    }

    public Pair<Long, ChatText> getBubble3() {
        return this.bubble3;
    }
}

