/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidPickupEntitiesTask
extends Behavior<EntityMaid> {
    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this((Predicate<EntityMaid>)Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.VISIBLE_PICKUP_ENTITIES.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return owner.m_21824_() && this.predicate.test(owner);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.getItems(maid).stream().filter(e -> maid.m_21444_(e.m_20183_()) && e.m_6084_() && !e.m_20069_()).filter(maid::canPathReach).findFirst().ifPresent(e -> BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0));
    }

    private List<Entity> getItems(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.VISIBLE_PICKUP_ENTITIES.get()).orElse(Lists.newArrayList());
    }
}

