/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidMilkTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 40;
    private final float speedModifier;
    private LivingEntity milkTarget = null;

    public MaidMilkTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(40);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        if (super.checkExtraStartConditions(worldIn, owner)) {
            CombinedInvWrapper availableInv = owner.getAvailableInv(true);
            return ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack.m_41720_() == Items.f_42446_) && ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack == ItemStack.f_41583_);
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.milkTarget = null;
        this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof Cow).filter(e -> !e.m_6162_()).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.milkTarget = e;
            BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.milkTarget != null && this.milkTarget.m_19950_((Entity)maid, 2.0)) {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            ItemStack bucket = ItemsUtil.getStack((IItemHandler)availableInv, stack -> stack.m_41720_() == Items.f_42446_);
            if (bucket != ItemStack.f_41583_) {
                bucket.m_41774_(1);
                ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)new ItemStack((ItemLike)Items.f_42455_), (boolean)false);
            }
            maid.m_6674_(InteractionHand.MAIN_HAND);
            maid.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            this.milkTarget = null;
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }
}

