/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MaidGomokuTask
extends MaidCheckRateTask {
    private final int closeEnoughDist;
    private final float speed;

    public MaidGomokuTask(float movementSpeed, int closeEnoughDist) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.closeEnoughDist = closeEnoughDist;
        this.speed = movementSpeed;
        this.setMaxCheckRate(10);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos gomokuPos = this.findGomoku(worldIn, maid);
            if (gomokuPos != null && maid.m_21444_(gomokuPos)) {
                if (gomokuPos.m_203193_((Position)maid.m_20182_()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(gomokuPos));
                    return true;
                }
                BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)gomokuPos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(targetPos -> {
            BlockPos pos = targetPos.m_6675_();
            BlockState blockState = worldIn.m_8055_(pos);
            Block patt2804$temp = blockState.m_60734_();
            if (patt2804$temp instanceof BlockGomoku) {
                BlockGomoku gomoku = (BlockGomoku)patt2804$temp;
                gomoku.startMaidSit(maid, blockState, (Level)worldIn, pos);
            }
        });
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    @Nullable
    private BlockPos findGomoku(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.m_8904_();
        int range = (int)maid.m_21535_();
        return poiManager.m_27181_(type -> ((PoiType)type.get()).equals(InitPoi.JOY_BLOCK.get()), blockPos, range, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(pos -> !this.isOccupied(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)maid.m_20183_()))).orElse(null);
    }

    private boolean isOccupied(ServerLevel worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityGomoku) {
            TileEntityGomoku gomoku = (TileEntityGomoku)te;
            return worldIn.m_8791_(gomoku.getSitId()) != null;
        }
        return true;
    }
}

