/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class PowerCommand {
    private static final String POWER_NAME = "power";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.m_82127_((String)POWER_NAME);
        RequiredArgumentBuilder targets = Commands.m_82129_((String)TARGETS_NAME, (ArgumentType)EntityArgument.m_91470_());
        RequiredArgumentBuilder count = Commands.m_82129_((String)COUNT_NAME, (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f));
        RequiredArgumentBuilder handleType = Commands.m_82129_((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(Commands.m_82127_((String)GET_NAME).then(targets.executes(PowerCommand::getPower)));
        pack.then(handleType.then(targets.then(count.executes(PowerCommand::handlePower))));
        return pack;
    }

    private static int handlePower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)TARGETS_NAME);
        float count = FloatArgumentType.getFloat(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (Player player : players) {
            switch (type) {
                case "set": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.set(count));
                    break;
                }
                case "add": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.add(count));
                    break;
                }
                case "min": {
                    player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> power.min(count));
                    break;
                }
            }
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.touhou_little_maid.power.handle.info", (Object[])new Object[]{players.size()}), true);
        return 1;
    }

    private static int getPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (Player player : EntityArgument.m_91477_(context, (String)TARGETS_NAME)) {
            player.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.touhou_little_maid.power.get.info", (Object[])new Object[]{player.m_6302_(), Float.valueOf(power.get())}), false));
        }
        return 1;
    }
}

