/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Converter;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FormatVersion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.RawGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.tree.RawGeometryTree;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.GeoBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.json.JsonAnimationUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.util.GsonHelper;

public class GeckoModelLoader {
    public static final ResourceLocation DEFAULT_MAID_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/maid.animation.json");
    public static final ResourceLocation DEFAULT_CHAIR_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/chair.animation.json");
    public static AnimationFile DEFAULT_MAID_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_CHAIR_ANIMATION_FILE = new AnimationFile();

    public static void reload() {
        GeckoModelLoader.clearAllCache();
        GeckoModelLoader.loadDefaultAnimation();
    }

    public static void registerGeo(ResourceLocation id, InputStream inputStream) {
        Map<ResourceLocation, GeoModel> geoModels = GeckoLibCache.getInstance().getGeoModels();
        RawGeoModel rawModel = Converter.fromInputStream(inputStream);
        if (rawModel.getFormatVersion() == FormatVersion.VERSION_1_12_0) {
            RawGeometryTree rawGeometryTree = RawGeometryTree.parseHierarchy(rawModel);
            GeoModel geoModel = GeoBuilder.getGeoBuilder(id.m_135827_()).constructGeoModel(rawGeometryTree);
            geoModels.put(id, geoModel);
        }
    }

    public static void registerMaidAnimations(ResourceLocation id, AnimationFile animationFile) {
        DEFAULT_MAID_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void registerChairAnimations(ResourceLocation id, AnimationFile animationFile) {
        DEFAULT_CHAIR_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void mergeAnimationFile(InputStream inputStream, AnimationFile animationFile) {
        GeckoModelLoader.mergeAnimationFile(animationFile, GeckoModelLoader.getAnimationFile(inputStream));
    }

    private static AnimationFile getAnimationFile(InputStream stream) {
        AnimationFile animationFile = new AnimationFile();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)CustomPackLoader.GSON, (Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry<String, JsonElement> entry : JsonAnimationUtils.getAnimations(jsonObject)) {
            String animationName = entry.getKey();
            try {
                Animation animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(jsonObject, animationName), parser);
                animationFile.putAnimation(animationName, animation);
            }
            catch (ChainedJsonException e) {
                e.printStackTrace();
            }
        }
        return animationFile;
    }

    private static AnimationFile mergeAnimationFile(AnimationFile main, AnimationFile other) {
        other.animations().forEach(main::putAnimation);
        return main;
    }

    private static void clearAllCache() {
        GeckoLibCache.getInstance().getGeoModels().clear();
    }

    private static void loadDefaultAnimation() {
        InputStream stream;
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_MAID_ANIMATION);
            try {
                DEFAULT_MAID_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_CHAIR_ANIMATION);
            try {
                DEFAULT_CHAIR_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

