/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.ShrineModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityShrineRenderer
implements BlockEntityRenderer<TileEntityShrine> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/shrine.png");
    private final ShrineModel model;

    public TileEntityShrineRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShrineModel(context.m_173582_(ShrineModel.LAYER));
    }

    public void render(TileEntityShrine shrine, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)shrine.m_58900_().m_61143_((Property)BlockGomoku.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)(180 - facing.m_122416_() * 90)));
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        this.model.m_7695_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        Level level = shrine.m_58904_();
        if (level == null) {
            return;
        }
        ItemStack stack = shrine.getStorageItem();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.85, 0.5);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float deg = ((float)level.m_46467_() + partialTick) % 360.0f;
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(deg));
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, 0);
        poseStack.m_85849_();
    }
}

