/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBannerModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;

public class GeckoLayerMaidBanner<T extends Mob>
extends GeoLayerRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/maid_banner.png");
    private final GeckoEntityMaidRenderer renderer;
    private final MaidBannerModel bannerModel;

    public GeckoLayerMaidBanner(GeckoEntityMaidRenderer renderer, EntityModelSet modelSet) {
        super(renderer);
        this.renderer = renderer;
        this.bannerModel = new MaidBannerModel(modelSet.m_171103_(MaidBannerModel.LAYER));
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        Item item = maid.getBackpackShowItem().m_41720_();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            if (!this.renderer.getMainInfo().isShowBackpack() || !InGameMaidConfig.INSTANCE.isShowBackItem() || entity.m_5803_() || entity.m_20145_()) {
                return;
            }
            GeoModel geoModel = this.entityRenderer.getGeoModel();
            if (geoModel != null && !geoModel.backpackBones.isEmpty()) {
                matrixStack.m_85836_();
                this.translateToBackpack(matrixStack, geoModel);
                matrixStack.m_85837_(0.0, -1.5, 0.02);
                matrixStack.m_85841_(0.65f, 0.65f, 0.65f);
                matrixStack.m_85845_(Vector3f.f_122222_.m_122240_(5.0f));
                VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
                this.bannerModel.m_7695_(matrixStack, buffer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                List list = BannerBlockEntity.m_58484_((DyeColor)bannerItem.m_40545_(), (ListTag)BannerBlockEntity.m_58487_((ItemStack)maid.getBackpackShowItem()));
                BannerRenderer.m_112065_((PoseStack)matrixStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (int)OverlayTexture.f_118083_, (ModelPart)this.bannerModel.getBanner(), (Material)ModelBakery.f_119224_, (boolean)true, (List)list);
                matrixStack.m_85849_();
            }
        }
    }

    private void translateToBackpack(PoseStack poseStack, GeoModel geoModel) {
        int size = geoModel.backpackBones.size();
        for (int i = 0; i < size - 1; ++i) {
            RenderUtils.prepMatrixForBone(poseStack, geoModel.backpackBones.get(i));
        }
        GeoBone lastBone = geoModel.backpackBones.get(size - 1);
        RenderUtils.translateMatrixToBone(poseStack, lastBone);
        RenderUtils.translateToPivotPoint(poseStack, lastBone);
        RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
        RenderUtils.scaleMatrixForBone(poseStack, lastBone);
    }
}

