/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;

public class ReplaceExperienceOrbRenderer
extends EntityRenderer<ExperienceOrb> {
    private static final ResourceLocation POINT_ITEM_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/point_item.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)POINT_ITEM_TEXTURE);
    private final ExperienceOrbRenderer vanillaRender;

    public ReplaceExperienceOrbRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.15f;
        this.f_114478_ = 0.75f;
        this.vanillaRender = new ExperienceOrbRenderer(context);
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pConsumer.m_85982_(pMatrix, pX, pY, 0.0f).m_6122_(pRed, pGreen, pBlue, 128).m_7421_(pTexU, pTexV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(pMatrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected int getBlockLightLevel(ExperienceOrb pEntity, BlockPos pPos) {
        return Mth.m_14045_((int)(super.m_6086_((Entity)pEntity, pPos) + 7), (int)0, (int)15);
    }

    public void render(ExperienceOrb orb, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_XP_TEXTURE.get()).booleanValue()) {
            this.renderPointItem(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.m_7392_(orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderPointItem(ExperienceOrb orb, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        int icon = orb.m_20802_();
        float texU1 = (float)(icon % 4 * 16) / 64.0f;
        float texU2 = (float)(icon % 4 * 16 + 16) / 64.0f;
        float texV2 = (float)(icon / 4 * 16) / 64.0f;
        float texV1 = (float)(icon / 4 * 16 + 16) / 64.0f;
        poseStack.m_85837_(0.0, (double)0.1f, 0.0);
        poseStack.m_85845_(this.f_114476_.m_114470_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        poseStack.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer consumer = buffer.m_6299_(RENDER_TYPE);
        PoseStack.Pose lasted = poseStack.m_85850_();
        Matrix4f pose = lasted.m_85861_();
        Matrix3f normal = lasted.m_85864_();
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, -0.25f, 255, 255, 255, texU1, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, -0.25f, 255, 255, 255, texU2, texV1, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, 0.5f, 0.75f, 255, 255, 255, texU2, texV2, packedLight);
        ReplaceExperienceOrbRenderer.vertex(consumer, pose, normal, -0.5f, 0.75f, 255, 255, 255, texU1, texV2, packedLight);
        poseStack.m_85849_();
        super.m_7392_((Entity)orb, pEntityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ExperienceOrb pEntity) {
        return POINT_ITEM_TEXTURE;
    }
}

