/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.TombstoneModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class EntityTombstoneRenderer
extends EntityRenderer<EntityTombstone> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone.png");
    private static final ResourceLocation THE_NETHER_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_the_nether.png");
    private static final ResourceLocation THE_END_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_the_end.png");
    private static final ResourceLocation TWILIGHT_FOREST_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/tombstone_twilight_forest.png");
    private static final ResourceLocation TWILIGHT_FOREST_NAME = new ResourceLocation("twilightforest", "twilight_forest");
    private static final int NAME_SHOW_DISTANCE = 64;
    private final TombstoneModel tombstoneModel;

    public EntityTombstoneRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.tombstoneModel = new TombstoneModel(manager.m_174023_(TombstoneModel.LAYER));
    }

    public void render(EntityTombstone tombstone, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, -1.501, 0.0);
        this.tombstoneModel.m_6973_(tombstone, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)this.getTextureLocation(tombstone));
        VertexConsumer buffer = bufferIn.m_6299_(renderType);
        this.tombstoneModel.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (this.shouldShowName(tombstone)) {
            this.renderNameTag(tombstone, (Component)Component.m_237115_((String)"entity.touhou_little_maid.tombstone.display").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}), 1.6f, poseStack, bufferIn, packedLight);
            this.renderNameTag(tombstone, tombstone.getMaidName(), 1.85f, poseStack, bufferIn, packedLight);
        }
    }

    protected boolean shouldShowName(EntityTombstone tombstone) {
        return !tombstone.getMaidName().equals(Component.m_237119_());
    }

    public ResourceLocation getTextureLocation(EntityTombstone entity) {
        ResourceLocation dimension = entity.f_19853_.m_46472_().m_135782_();
        if (dimension.equals((Object)Level.f_46429_.m_135782_())) {
            return THE_NETHER_TEXTURE;
        }
        if (dimension.equals((Object)Level.f_46430_.m_135782_())) {
            return THE_END_TEXTURE;
        }
        if (dimension.equals((Object)TWILIGHT_FOREST_NAME)) {
            return TWILIGHT_FOREST_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    private void renderNameTag(EntityTombstone tombstone, Component component, float yOffset, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        double distance = this.f_114476_.m_114471_((Entity)tombstone);
        if (distance < 4096.0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)yOffset, 0.0);
            poseStack.m_85845_(this.f_114476_.m_114470_());
            poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            Font font = this.m_114481_();
            float width = -font.m_92852_((FormattedText)component) / 2;
            font.m_92841_(component, width, 0.0f, -1, false, matrix4f, bufferSource, false, 0, packedLight);
            poseStack.m_85849_();
        }
    }
}

