/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.EntityMarisaYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MagmaCubeRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.MagmaCube;

public class EntityMarisaYukkuriSlimeRender
extends MobRenderer<MagmaCube, EntityMarisaYukkuriModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/marisa_yukkuri.png");
    private final MagmaCubeRenderer vanillaRender;

    public EntityMarisaYukkuriSlimeRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EntityMarisaYukkuriModel(context.m_174023_(EntityMarisaYukkuriModel.LAYER)), 0.25f);
        this.vanillaRender = new MagmaCubeRenderer(context);
    }

    public void render(MagmaCube slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_SLIME_MODEL.get()).booleanValue()) {
            this.renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.m_7392_((Mob)slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    protected int getBlockLightLevel(MagmaCube pEntity, BlockPos pPos) {
        return 15;
    }

    private void renderYukkuri(MagmaCube slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = 0.25f * (float)slime.m_33632_();
        super.m_7392_((Mob)slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(MagmaCube slime, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(0.999f, 0.999f, 0.999f);
        poseStack.m_85837_(0.0, (double)0.001f, 0.0);
        float slimeSize = slime.m_33632_();
        float tmp = Mth.m_14179_((float)partialTicks, (float)slime.f_33585_, (float)slime.f_33584_) / (slimeSize * 0.5f + 1.0f);
        float scale = 1.0f / (tmp + 1.0f);
        poseStack.m_85841_(scale * slimeSize, 1.0f / scale * slimeSize, scale * slimeSize);
    }

    public ResourceLocation getTextureLocation(MagmaCube slime) {
        return TEXTURE;
    }
}

