/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityChairRenderer
extends LivingEntityRenderer<EntityChair, BedrockModel<EntityChair>> {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_CHAIR_ID = "touhou_little_maid:cushion";
    public static boolean renderHitBox = true;
    private ChairModelInfo chairInfo;
    private List<Object> chairAnimations;
    private GeckoEntityChairRenderer geckoEntityChairRenderer;

    public EntityChairRenderer(EntityRendererProvider.Context rendererManager) {
        super(rendererManager, new BedrockModel(), 0.0f);
        this.geckoEntityChairRenderer = new GeckoEntityChairRenderer(rendererManager);
    }

    public void render(EntityChair chair, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.canShowHitBox((Player)player) && renderHitBox) {
            this.renderHitBox(chair, poseStack, bufferIn);
        } else {
            this.renderChair(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        }
    }

    private boolean canShowHitBox(@Nullable Player player) {
        if (player != null && player.m_6144_()) {
            return player.m_21205_().m_41720_() == InitItems.CHAIR_SHOW.get();
        }
        return false;
    }

    private void renderHitBox(EntityChair chair, PoseStack poseStack, MultiBufferSource bufferIn) {
        AABB aabb = chair.m_20191_().m_82386_(-chair.m_20185_(), -chair.m_20186_(), -chair.m_20189_());
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)bufferIn.m_6299_(RenderType.m_110504_()), (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void renderChair(EntityChair chair, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        CustomPackLoader.CHAIR_MODELS.getModel(DEFAULT_CHAIR_ID).ifPresent(model -> {
            this.f_115290_ = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(DEFAULT_CHAIR_ID).ifPresent(info -> {
            this.chairInfo = info;
        });
        this.chairAnimations = null;
        CustomPackLoader.CHAIR_MODELS.getModel(chair.getModelId()).ifPresent(model -> {
            this.f_115290_ = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(chair.getModelId()).ifPresent(info -> {
            this.chairInfo = info;
        });
        CustomPackLoader.CHAIR_MODELS.getAnimation(chair.getModelId()).ifPresent(animations -> {
            this.chairAnimations = animations;
        });
        if (this.chairInfo.isGeckoModel()) {
            this.geckoEntityChairRenderer.setMainInfo(this.chairInfo);
            this.geckoEntityChairRenderer.m_7392_((Entity)chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.f_115290_).setAnimations(this.chairAnimations);
        GlWrapper.setPoseStack(poseStack);
        super.m_7392_((LivingEntity)chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    protected void scale(EntityChair chair, PoseStack poseStack, float partialTickTime) {
        float scale = this.chairInfo.getRenderEntityScale();
        poseStack.m_85841_(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(EntityChair entity) {
        if (this.chairInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.chairInfo.getTexture();
    }

    protected void setupRotations(EntityChair chair, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
    }

    protected boolean shouldShowName(EntityChair entity) {
        return entity.m_6052_();
    }
}

