/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model.bedrock;

import com.github.tartaricacid.touhoulittlemaid.client.animation.CustomJsAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityChairWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.EntityMaidWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockCubeBox;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockCubePerFace;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BedrockModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BonesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.CubesItem;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.Description;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.FaceUVsItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.script.Invocable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BedrockModel<T extends LivingEntity>
extends EntityModel<T> {
    protected final HashMap<String, ModelRendererWrapper> modelMap = new HashMap();
    private final HashMap<String, BonesItem> indexBones = new HashMap();
    private final List<BedrockPart> shouldRender = new LinkedList<BedrockPart>();
    private final EntityMaidWrapper entityMaidWrapper = new EntityMaidWrapper();
    private final EntityChairWrapper entityChairWrapper = new EntityChairWrapper();
    private AABB renderBoundingBox;
    private List<Object> animations = Lists.newArrayList();

    public BedrockModel() {
        super(RenderType::m_110473_);
        this.renderBoundingBox = new AABB(-1.0, 0.0, -1.0, 1.0, 2.0, 1.0);
    }

    public BedrockModel(BedrockModelPOJO pojo, BedrockVersion version) {
        super(RenderType::m_110473_);
        if (version == BedrockVersion.LEGACY) {
            this.loadLegacyModel(pojo);
        }
        if (version == BedrockVersion.NEW) {
            this.loadNewModel(pojo);
        }
    }

    protected void loadNewModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelNew() != null);
        pojo.getGeometryModelNew().deco();
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        List<Float> offset = description.getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AABB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new BedrockPart()));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name).getModelRenderer();
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().addChild(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                FaceUVsItem faceUv = cube.getFaceUv();
                List<Float> size = cube.getSize();
                List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                        continue;
                    }
                    model.cubes.add((Object)new BedrockCubePerFace(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, texWidth, texHeight, faceUv));
                    continue;
                }
                BedrockPart cubeRenderer = new BedrockPart();
                cubeRenderer.setPos(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, this.convertRotation(cubeRotation.get(0).floatValue()), this.convertRotation(cubeRotation.get(1).floatValue()), this.convertRotation(cubeRotation.get(2).floatValue()));
                if (faceUv == null) {
                    cubeRenderer.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                } else {
                    cubeRenderer.cubes.add((Object)new BedrockCubePerFace(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, texWidth, texHeight, faceUv));
                }
                model.addChild(cubeRenderer);
            }
        }
    }

    protected void loadLegacyModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelLegacy() != null);
        pojo.getGeometryModelLegacy().deco();
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        List<Float> offset = pojo.getGeometryModelLegacy().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        float width = pojo.getGeometryModelLegacy().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModelLegacy().getVisibleBoundsHeight() / 2.0f;
        this.renderBoundingBox = new AABB((double)(offsetX - width), (double)(offsetY - height), (double)(offsetZ - width), (double)(offsetX + width), (double)(offsetY + height), (double)(offsetZ + width));
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.put(bones.getName(), bones);
            this.modelMap.put(bones.getName(), new ModelRendererWrapper(new BedrockPart()));
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            List<Float> rotation = bones.getRotation();
            String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name).getModelRenderer();
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).getModelRenderer().addChild(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                model.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.animations != null) {
            Invocable invocable = (Invocable)((Object)CustomJsAnimationManger.NASHORN);
            if (entityIn instanceof EntityMaid) {
                this.setupMaidAnim((EntityMaid)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
                return;
            }
            if (entityIn instanceof EntityChair) {
                this.setupChairAnim((EntityChair)((Object)entityIn), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, invocable);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (BedrockPart model : this.shouldRender) {
            model.render(poseStack, buffer, packedLight, packedOverlay);
        }
    }

    private void setupMaidAnim(EntityMaid entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn, this.modelMap);
                    continue;
                }
                this.entityMaidWrapper.setData(entityIn, this.f_102608_, this.f_102609_);
                invocable.invokeMethod(animation, "animation", this.entityMaidWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMap);
                this.entityMaidWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.MAID_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    private void setupChairAnim(EntityChair entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, Invocable invocable) {
        try {
            for (Object animation : this.animations) {
                if (animation instanceof IAnimation) {
                    ((IAnimation)animation).setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 0.0f, entityIn, this.modelMap);
                    continue;
                }
                this.entityChairWrapper.setData(entityIn);
                invocable.invokeMethod(animation, "animation", this.entityChairWrapper, Float.valueOf(limbSwing), Float.valueOf(limbSwingAmount), Float.valueOf(ageInTicks), Float.valueOf(netHeadYaw), Float.valueOf(headPitch), Float.valueOf(0.0625f), this.modelMap);
                this.entityChairWrapper.clearData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomPackLoader.CHAIR_MODELS.removeAnimation(entityIn.getModelId());
        }
    }

    private void setRotationAngle(BedrockPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
        modelRenderer.setInitRotationAngle(x, y, z);
    }

    public void translateToHand(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart arm = this.getArm(sideIn);
        if (arm != null) {
            arm.translateAndRotate(poseStack);
        }
    }

    public boolean hasBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone") != null;
    }

    public BedrockPart getBackpackPositioningModel() {
        return this.modelMap.get("backpackPositioningBone").getModelRenderer();
    }

    @Nullable
    private BedrockPart getArm(HumanoidArm sideIn) {
        return sideIn == HumanoidArm.LEFT ? this.modelMap.get("armLeft").getModelRenderer() : this.modelMap.get("armRight").getModelRenderer();
    }

    public boolean hasHead() {
        return this.modelMap.containsKey("head");
    }

    public BedrockPart getHead() {
        return this.modelMap.get("head").getModelRenderer();
    }

    public boolean hasLeftArm() {
        return this.modelMap.containsKey("armLeft");
    }

    public boolean hasRightArm() {
        return this.modelMap.containsKey("armRight");
    }

    public boolean hasArmPositioningModel(HumanoidArm side) {
        ModelRendererWrapper arm = side == HumanoidArm.LEFT ? this.modelMap.get("armLeftPositioningBone") : this.modelMap.get("armRightPositioningBone");
        return arm != null;
    }

    public void translateToPositioningHand(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart arm;
        BedrockPart bedrockPart = arm = sideIn == HumanoidArm.LEFT ? this.modelMap.get("armLeftPositioningBone").getModelRenderer() : this.modelMap.get("armRightPositioningBone").getModelRenderer();
        if (arm != null) {
            arm.translateAndRotate(poseStack);
        }
    }

    public boolean hasWaistPositioningModel(HumanoidArm side) {
        ModelRendererWrapper waist = side == HumanoidArm.LEFT ? this.modelMap.get("waistLeftPositioningBone") : this.modelMap.get("waistRightPositioningBone");
        return waist != null;
    }

    public void translateToPositioningWaist(HumanoidArm sideIn, PoseStack poseStack) {
        BedrockPart waist;
        BedrockPart bedrockPart = waist = sideIn == HumanoidArm.LEFT ? this.modelMap.get("waistLeftPositioningBone").getModelRenderer() : this.modelMap.get("waistRightPositioningBone").getModelRenderer();
        if (waist != null) {
            waist.translateAndRotate(poseStack);
        }
    }

    private float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    private float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    private float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    private float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    private float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }

    public void setAnimations(@Nullable List<Object> animations) {
        this.animations = animations;
    }

    public AABB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }
}

