/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class SoundPackButton
extends FlatColorButton {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_custom_sound.png");
    private final SoundPackInfo info;
    private boolean isUse = false;

    public SoundPackButton(int pX, int pY, SoundPackInfo info, Button.OnPress onPress) {
        super(pX, pY, 230, 43, (Component)Component.m_237119_(), onPress);
        this.info = info;
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float pPartialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, pPartialTick);
        ResourceLocation icon = this.info.getIcon();
        if (icon == null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICON);
            SoundPackButton.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + 4), (int)(this.f_93621_ + 5), (float)0.0f, (float)16.0f, (int)32, (int)32, (int)256, (int)256);
        } else {
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(this.info, icon);
            }
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                SoundPackButton.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + 4), (int)(this.f_93621_ + 5), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            } else {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                int time = this.getTickTime() / this.info.getIconDelay();
                int iconIndex = time % this.info.getIconAspectRatio();
                SoundPackButton.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + 4), (int)(this.f_93621_ + 5), (float)0.0f, (float)(iconIndex * 32), (int)32, (int)32, (int)32, (int)(32 * this.info.getIconAspectRatio()));
            }
        }
        if (this.isUse) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICON);
            SoundPackButton.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + this.m_5711_() - 20), (int)(this.f_93621_ + 13), (float)32.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
        }
    }

    @Override
    public void renderString(PoseStack poseStack, Font font, int pColor) {
        int startX = this.f_93620_ + 42;
        int startY = this.f_93621_ + 7;
        MutableComponent packName = ParseI18n.parse(this.info.getPackName());
        String version = this.info.getVersion();
        List<String> author = this.info.getAuthor();
        String date = this.info.getDate();
        SoundPackButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)packName, (int)startX, (int)startY, (int)ChatFormatting.WHITE.m_126665_());
        if (StringUtils.isNotBlank((CharSequence)version)) {
            int titleWidth = font.m_92852_((FormattedText)packName);
            SoundPackButton.m_93236_((PoseStack)poseStack, (Font)font, (String)("\u00a7nv" + version), (int)(startX + titleWidth + 5), (int)startY, (int)ChatFormatting.AQUA.m_126665_());
        }
        if (!author.isEmpty()) {
            String authorListText = StringUtils.joinWith((String)I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), (Object[])new Object[]{author});
            String authorText = I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{authorListText});
            SoundPackButton.m_93236_((PoseStack)poseStack, (Font)font, (String)authorText, (int)startX, (int)(startY += 10), (int)ChatFormatting.GOLD.m_126665_());
        }
        if (StringUtils.isNotBlank((CharSequence)date)) {
            MutableComponent dateText = Component.m_237110_((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{date});
            SoundPackButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)dateText, (int)startX, (int)(startY += 10), (int)ChatFormatting.GREEN.m_126665_());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(SoundPackInfo info, ResourceLocation icon) {
        AbstractTexture iconText = Minecraft.m_91087_().f_90987_.m_118506_(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                info.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                info.setIconAspectRatio(height / width);
            }
        } else {
            info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    public void setUse(boolean use) {
        this.isUse = use;
    }
}

