/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PackInfoButton
extends FlatColorButton {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private final DownloadInfo info;

    public PackInfoButton(int pX, int pY, DownloadInfo info, Button.OnPress onPress) {
        super(pX, pY, 268, 46, (Component)Component.m_237119_(), onPress);
        this.info = info;
        this.setTooltips(Lists.newArrayList((Object[])new Component[]{this.getI18nFormatDesc(info.getDesc()), this.getI18nFormatLicense(info.getLicense())}));
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float pPartialTick) {
        int count;
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        if (this.isSelect) {
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, -14774017, -14774017);
        } else if (this.info.getStatus() != DownloadStatus.DOWNLOADED) {
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, -12369342, -12369342);
        }
        if (this.info.getStatus() == DownloadStatus.NEED_UPDATE) {
            this.m_93228_(poseStack, this.f_93620_ + 240, this.f_93621_ + 15, 48, 16, 16, 16);
        }
        if (this.m_198029_()) {
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_ + 1, this.f_93620_ + 1, this.f_93621_ + this.f_93619_ - 1, -790560, -790560);
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + 1, -790560, -790560);
            this.m_93179_(poseStack, this.f_93620_ + this.f_93618_ - 1, this.f_93621_ + 1, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_ - 1, -790560, -790560);
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_ + this.f_93619_ - 1, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, -790560, -790560);
        }
        if ((count = this.info.getTypeCount()) == 3) {
            this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 0, 96, 32, 32);
        } else if (count == 2) {
            if (!this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
                this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 64, 64, 32, 32);
            } else if (!this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 32, 64, 32, 32);
            } else {
                this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 0, 64, 32, 32);
            }
        } else if (this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
            this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 0, 32, 32, 32);
        } else if (this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
            this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 32, 32, 32, 32);
        } else {
            this.m_93228_(poseStack, this.f_93620_ + 7, this.f_93621_ + 7, 64, 32, 32, 32);
        }
        int i = this.getFGColor();
        this.renderString(poseStack, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        if (this.info.getStatus() == DownloadStatus.DOWNLOADED) {
            this.m_93179_(poseStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, 2133008930, 2133008930);
        }
    }

    @Override
    public void renderString(PoseStack poseStack, Font font, int pColor) {
        int startX = this.f_93620_ + 50;
        int startY = this.f_93621_ + 4;
        MutableComponent packName = Component.m_237115_((String)this.info.getName());
        PackInfoButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)packName, (int)startX, (int)startY, (int)ChatFormatting.WHITE.m_126665_());
        PackInfoButton.m_93236_((PoseStack)poseStack, (Font)font, (String)this.getI18nFormatFileVersion(this.info.getVersion()), (int)(startX + 5 + font.m_92852_((FormattedText)packName)), (int)startY, (int)ChatFormatting.GREEN.m_126665_());
        PackInfoButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.getI18nFormatFileSize(this.info.getFormatFileSize()), (int)startX, (int)(startY + 10), (int)ChatFormatting.GOLD.m_126665_());
        PackInfoButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.getI18nFormatAuthor(this.info.getAuthor()), (int)startX, (int)(startY + 20), (int)ChatFormatting.AQUA.m_126665_());
        PackInfoButton.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.getI18nFormatFileTime(this.info.getFormatData()), (int)startX, (int)(startY + 30), (int)ChatFormatting.GRAY.m_126665_());
    }

    private String getI18nFormatFileVersion(String version) {
        return "\u00a7nv" + version;
    }

    private MutableComponent getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private MutableComponent getI18nFormatFileSize(String size) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }

    private MutableComponent getI18nFormatFileTime(String time) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.upload_time", (Object[])new Object[]{time});
    }

    private MutableComponent getI18nFormatLicense(String license) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.license", (Object[])new Object[]{license}).m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC);
    }

    private MutableComponent getI18nFormatDesc(String desc) {
        return Component.m_237115_((String)desc).m_130940_(ChatFormatting.GRAY);
    }
}

