/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.model.DebugFloorModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.Rectangle;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public abstract class AbstractModelDetailsGui<T extends LivingEntity, E extends IModelInfo>
extends Screen {
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/gui/skin_detail.png");
    private static final ResourceLocation FLOOR_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/debug_floor.png");
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 18.0f;
    private static final float PITCH_MAX = 90.0f;
    private static final float PITCH_MIN = -90.0f;
    private static Rectangle BACKGROUND_SIZE;
    private static Rectangle BOTTOM_STATUS_BAR_SIZE;
    private static Rectangle SIDE_MENU_SIZE;
    private static Rectangle TOP_STATUS_BAR_SIZE;
    protected final DebugFloorModel floorModel;
    protected T sourceEntity;
    protected volatile T guiEntity;
    protected E modelInfo;
    private float posX = 0.0f;
    private float posY = 25.0f;
    private float scale = 80.0f;
    private float yaw = 145.0f;
    private float pitch = 0.0f;
    private boolean showFloor = true;

    public AbstractModelDetailsGui(T sourceEntity, @Nullable T guiEntity, E modelInfo) {
        super((Component)Component.m_237115_((String)"gui.touhou_little_maid.custom_model_details_gui.title"));
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelInfo = modelInfo;
        this.floorModel = new DebugFloorModel(Minecraft.m_91087_().m_167973_().m_171103_(DebugFloorModel.LAYER));
    }

    protected abstract void applyReturnButtonLogic();

    protected abstract void initSideButton();

    protected abstract void renderExtraEntity(EntityRenderDispatcher var1, PoseStack var2, MultiBufferSource.BufferSource var3);

    protected void m_7856_() {
        this.m_169413_();
        BACKGROUND_SIZE = new Rectangle(0.0, 0.0, this.f_96543_, this.f_96544_);
        BOTTOM_STATUS_BAR_SIZE = new Rectangle(0.0, this.f_96544_ - 16, this.f_96543_, this.f_96544_);
        SIDE_MENU_SIZE = new Rectangle(0.0, 0.0, 132.0, this.f_96544_);
        TOP_STATUS_BAR_SIZE = new Rectangle(0.0, 0.0, this.f_96543_, 15.0);
        ImageButton closeButton = new ImageButton(this.f_96543_ - 15, 0, 15, 15, 0, 24, 15, BUTTON_TEXTURE, b -> Minecraft.m_91087_().m_91152_(null));
        ImageButton floorButton = new ImageButton(this.f_96543_ - 30, 0, 15, 15, 30, 24, 15, BUTTON_TEXTURE, b -> {
            this.showFloor = !this.showFloor;
        });
        ImageButton returnButton = new ImageButton(this.f_96543_ - 45, 0, 15, 15, 15, 24, 15, BUTTON_TEXTURE, b -> this.applyReturnButtonLogic());
        this.m_142416_((GuiEventListener)closeButton);
        this.m_142416_((GuiEventListener)floorButton);
        this.m_142416_((GuiEventListener)returnButton);
        this.initSideButton();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        this.renderViewBg(stack);
        this.renderEntity((this.f_96543_ + 132) / 2, this.f_96544_ / 2 + 50);
        this.renderViewCrosshair();
        this.renderBottomStatueBar(stack);
        this.fillGradient(stack, SIDE_MENU_SIZE, -31382229);
        this.fillGradient(stack, TOP_STATUS_BAR_SIZE, -30921676);
        AbstractModelDetailsGui.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)6, (int)4, (int)-5592406);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    private void renderViewBg(PoseStack stack) {
        this.fillGradient(stack, BACKGROUND_SIZE, -32040675, -999);
        stack.m_85836_();
        stack.m_85837_(0.0, 0.0, -900.0);
        AbstractModelDetailsGui.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.skin_details.left_mouse"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 4), (int)-5592406);
        AbstractModelDetailsGui.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.skin_details.right_mouse"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 14), (int)-5592406);
        AbstractModelDetailsGui.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.skin_details.mouse_wheel"), (int)((int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4), (int)((int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 24), (int)-5592406);
        stack.m_85849_();
    }

    private void renderBottomStatueBar(PoseStack stack) {
        this.fillGradient(stack, BOTTOM_STATUS_BAR_SIZE, -30921676);
        String name = String.format("%s %s", "\u2714", I18n.m_118938_((String)ParseI18n.getI18nKey(this.modelInfo.getName()), (Object[])new Object[0]));
        String info = String.format("%d FPS %.2f%%", Minecraft.f_91021_, Float.valueOf(this.scale * 100.0f / 80.0f));
        AbstractModelDetailsGui.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)name, (int)136, (int)(this.f_96544_ - 12), (int)13290196);
        AbstractModelDetailsGui.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)info, (int)(this.f_96543_ - this.f_96547_.m_92895_(info) - 4), (int)(this.f_96544_ - 12), (int)13290196);
    }

    private void renderViewCrosshair() {
        if (this.f_96541_ != null) {
            Camera camera = this.f_96541_.f_91063_.m_109153_();
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)(this.f_96543_ - 16), (double)(this.f_96544_ - 32), -20.0);
            posestack.m_85845_(Vector3f.f_122222_.m_122240_(camera.m_90589_()));
            posestack.m_85845_(Vector3f.f_122225_.m_122240_(camera.m_90590_()));
            posestack.m_85841_(-1.0f, -1.0f, -1.0f);
            RenderSystem.m_157182_();
            RenderSystem.m_69881_((int)10);
            posestack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.f_96543_ - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.f_96544_ - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.f_96541_ == null || !isInRange) {
            return false;
        }
        if (button == 0) {
            this.yaw = (float)((double)this.yaw + dragX);
            this.changePitchValue((float)dragY);
        }
        if (button == 1) {
            this.posX = (float)((double)this.posX + dragX);
            this.posY = (float)((double)this.posY + dragY);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.f_96543_ - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.f_96544_ - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.f_96541_ == null || !isInRange) {
            return false;
        }
        if (delta != 0.0) {
            this.changeScaleValue((float)delta * 0.07f);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void changePitchValue(float amount) {
        this.pitch = this.pitch - amount > 90.0f ? 90.0f : (this.pitch - amount < -90.0f ? -90.0f : (this.pitch -= amount));
    }

    private void changeScaleValue(float amount) {
        float tmp = this.scale + amount * this.scale;
        this.scale = Mth.m_14036_((float)tmp, (float)18.0f, (float)360.0f);
    }

    private void renderEntity(int middleWidth, int middleHeight) {
        PoseStack viewStack = RenderSystem.m_157191_();
        viewStack.m_85836_();
        viewStack.m_85837_((double)(this.posX + (float)middleWidth), (double)(this.posY + (float)middleHeight), 1050.0);
        viewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        Quaternion zp = Vector3f.f_122227_.m_122240_(-180.0f);
        Quaternion yp = Vector3f.f_122225_.m_122240_(this.yaw);
        Quaternion xp = Vector3f.f_122223_.m_122240_(-this.pitch);
        yp.m_80148_(xp);
        zp.m_80148_(yp);
        poseStack.m_85845_(zp);
        Lighting.m_166384_();
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        xp.m_80157_();
        manager.m_114412_(xp);
        manager.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> {
            manager.m_114384_(this.guiEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
            poseStack.m_85837_(0.0, 0.5, 0.0);
            if (this.showFloor) {
                this.floorModel.m_7695_(poseStack, buffer.m_6299_(this.floorModel.m_103119_(FLOOR_TEXTURE)), 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.renderExtraEntity(manager, poseStack, buffer);
        });
        buffer.m_109911_();
        manager.m_114468_(true);
        viewStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void fillGradient(PoseStack poseStack, Rectangle vec4d, int color) {
        this.m_93179_(poseStack, (int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, color, color);
    }

    private void fillGradient(PoseStack poseStack, Rectangle vec4d, int color, int zLevel) {
        int blitOffset = this.m_93252_();
        this.m_93250_(zLevel);
        this.fillGradient(poseStack, vec4d, color);
        this.m_93250_(blitOffset);
    }
}

