/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BeaconEffectButton;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class MaidBeaconGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final TileEntityMaidBeacon beacon;
    protected int imageWidth = 300;
    protected int imageHeight = 113;
    protected int leftPos;
    protected int topPos;
    private boolean overflowDelete;
    private int potionIndex;

    public MaidBeaconGui(TileEntityMaidBeacon beacon) {
        super((Component)Component.m_237113_((String)"Maid Beacon GUI"));
        this.beacon = beacon;
        this.overflowDelete = beacon.isOverflowDelete();
        this.potionIndex = beacon.getPotionIndex();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.addEffectButton(this.leftPos + 146, 26, this.topPos + 19);
        this.addStorageAndTakeButton();
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 118, this.topPos + 94, 154, 20, (Component)this.getOverflowDeleteButtonText(this.overflowDelete), b -> {
            this.overflowDelete = !this.overflowDelete;
            NetworkHandler.CHANNEL.sendToServer((Object)new SetBeaconOverflowMessage(this.beacon.m_58899_(), this.overflowDelete));
            this.m_7856_();
        }));
    }

    private void addStorageAndTakeButton() {
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 118, this.topPos + 72, 76, 20, (Component)Component.m_237115_((String)"gui.touhou_little_maid.maid_beacon.add_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), 1.0f, true))));
        this.m_142416_((GuiEventListener)new Button(this.leftPos + 196, this.topPos + 72, 76, 20, (Component)Component.m_237115_((String)"gui.touhou_little_maid.maid_beacon.min_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.m_58899_(), 1.0f, false))));
    }

    private void addEffectButton(int start, int spacing, int y) {
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.SPEED, start, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.SPEED.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE, start + spacing, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.STRENGTH, start + spacing * 2, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.STRENGTH.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.RESISTANCE, start + spacing * 3, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.RESISTANCE.ordinal() : -1;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.REGENERATION, start + spacing * 4, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.REGENERATION.ordinal() : -1;
            this.m_7856_();
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(poseStack, this.leftPos, this.topPos + 2, 0, 0, 142, 111);
        this.m_93228_(poseStack, this.leftPos + 118, this.topPos + 1, 44, 111, 154, 15);
        this.m_93228_(poseStack, this.leftPos + 224, this.topPos + 44, 44, 126, 12, 12);
        this.m_93228_(poseStack, this.leftPos + 224, this.topPos + 58, 44, 138, 12, 12);
        this.m_93228_(poseStack, this.leftPos + 146, this.topPos + 46, 58, 128, 74, 9);
        this.m_93228_(poseStack, this.leftPos + 146, this.topPos + 59, 58, 128, 74, 9);
        float percent = this.beacon.getStoragePower() / this.beacon.getMaxStorage();
        this.m_93228_(poseStack, this.leftPos + 146, this.topPos + 48, 58, 138, (int)(74.0f * percent), 5);
        this.renderPlayerPower(poseStack);
        MaidBeaconGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)DECIMAL_FORMAT.format(this.beacon.getStoragePower()), (int)(this.leftPos + 240), (int)(this.topPos + 46), (int)0xFFFFFF);
        if (this.potionIndex == -1) {
            this.drawCenteredStringNoShadow(poseStack, this.f_96547_, I18n.m_118938_((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(0L)}), this.leftPos + 195, this.topPos + 5, (int)ChatFormatting.DARK_GRAY.m_126665_());
        } else {
            this.drawCenteredStringNoShadow(poseStack, this.f_96547_, (Component)Component.m_237110_((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(this.beacon.getEffectCost() * 900.0f)}).m_130940_(ChatFormatting.RED), this.leftPos + 195, this.topPos + 5, 0xFFFFFF);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.f_169369_.stream().filter(b -> b instanceof BeaconEffectButton).forEach(b -> ((BeaconEffectButton)((Object)b)).renderToolTip(poseStack, this, mouseX, mouseY));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void renderPlayerPower(PoseStack poseStack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> {
                float percent = power.get() / 5.0f;
                this.m_93228_(poseStack, this.leftPos + 146, this.topPos + 61, 58, 143, (int)(74.0f * percent), 5);
                MaidBeaconGui.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)DECIMAL_FORMAT.format(power.get()), (int)(this.leftPos + 240), (int)(this.topPos + 60), (int)0xFFFFFF);
            });
        }
    }

    private MutableComponent getOverflowDeleteButtonText(boolean overflowDelete) {
        return overflowDelete ? Component.m_237115_((String)"gui.touhou_little_maid.maid_beacon.overflow_delete_true") : Component.m_237115_((String)"gui.touhou_little_maid.maid_beacon.overflow_delete_false");
    }

    private void drawCenteredStringNoShadow(PoseStack matrixStack, Font font, String text, int pX, int pY, int color) {
        font.m_92883_(matrixStack, text, (float)pX - (float)font.m_92895_(text) / 2.0f, (float)pY, color);
    }

    private void drawCenteredStringNoShadow(PoseStack matrixStack, Font font, Component text, int pX, int pY, int color) {
        font.m_92889_(matrixStack, text, (float)pX - (float)font.m_92852_((FormattedText)text) / 2.0f, (float)pY, color);
    }
}

