/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class CompassRenderEvent {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            BlockPos resetPos;
            BlockPos idlePos;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            ItemStack stack = mc.f_91074_.m_21205_();
            if (stack.m_41720_() != InitItems.KAPPA_COMPASS.get() && (stack = mc.f_91074_.m_21206_()).m_41720_() != InitItems.KAPPA_COMPASS.get()) {
                return;
            }
            if (!ItemKappaCompass.hasKappaCompassData(stack)) {
                return;
            }
            ResourceLocation dimension = ItemKappaCompass.getDimension(stack);
            if (dimension != null && !mc.f_91074_.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) {
                return;
            }
            BlockPos workPos = ItemKappaCompass.getPoint(Activity.f_37980_, stack);
            Vec3 camera = event.getCamera().m_90583_().m_82548_();
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_85837_(0.0, 1.0, 0.0);
            if (workPos != null) {
                Vec3 centerPos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
                double radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
                VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
                Vec3 textPos = new Vec3((double)workPos.m_123341_() + 0.5, (double)(workPos.m_123342_() + 2), (double)workPos.m_123343_() + 0.5);
                String text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0xFF1111, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0xFF1111, 0.15f, true, 5.0f, false);
            }
            if ((idlePos = ItemKappaCompass.getPoint(Activity.f_37979_, stack)) != null) {
                Vec3 centerPos = camera.m_82520_((double)idlePos.m_123341_() + 0.5, (double)idlePos.m_123342_() + 0.5, (double)idlePos.m_123343_() + 0.5);
                double radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
                VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
                Vec3 textPos = new Vec3((double)idlePos.m_123341_() + 0.5, (double)(idlePos.m_123342_() + 2), (double)idlePos.m_123343_() + 0.5);
                if (idlePos.equals((Object)workPos)) {
                    textPos = textPos.m_82520_(0.0, 1.0, 0.0);
                } else if (workPos != null) {
                    Vec3 prePos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                }
                String text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x11FF11, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x11FF11, 0.15f, true, 5.0f, false);
            }
            if ((resetPos = ItemKappaCompass.getPoint(Activity.f_37982_, stack)) != null) {
                Vec3 centerPos = camera.m_82520_((double)resetPos.m_123341_() + 0.5, (double)resetPos.m_123342_() + 0.5, (double)resetPos.m_123343_() + 0.5);
                double radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
                VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
                RenderHelper.renderCylinder(event.getPoseStack(), buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
                Vec3 textPos = new Vec3((double)resetPos.m_123341_() + 0.5, (double)(resetPos.m_123342_() + 2), (double)resetPos.m_123343_() + 0.5);
                if (resetPos.equals((Object)idlePos)) {
                    textPos = textPos.m_82520_(0.0, 2.0, 0.0);
                } else if (idlePos != null && workPos != null) {
                    Vec3 prePos = camera.m_82520_((double)idlePos.m_123341_() + 0.5, (double)idlePos.m_123342_() + 0.5, (double)idlePos.m_123343_() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                    prePos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
                    RenderHelper.renderLine(event.getPoseStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                }
                String text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
                RenderHelper.renderFloatingText(event.getPoseStack(), text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x1111FF, 0.15f, true, -5.0f, false);
                RenderHelper.renderFloatingText(event.getPoseStack(), "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x1111FF, 0.15f, true, 5.0f, false);
            }
            event.getPoseStack().m_85849_();
        }
    }
}

