/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.entity;

import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationFactory;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.GeckoLibUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class GeckoChairEntity
implements IAnimatable {
    private static final ResourceLocation GECKO_DEFAULT_ID = new ResourceLocation("touhou_little_maid", "fox_miko");
    private final AnimationFactory factory = GeckoLibUtil.createFactory(this, true);
    private EntityChair chair = null;
    private ChairModelInfo chairInfo;

    @Override
    public void registerControllers(AnimationData data) {
        for (int i = 0; i < 8; ++i) {
            String controllerName = String.format("parallel_%d_controller", i);
            String animationName = String.format("parallel%d", i);
            data.addAnimationController(new AnimationController<GeckoChairEntity>(this, controllerName, 0.0f, e -> this.predicateParallel(e, animationName)));
        }
    }

    public ResourceLocation getModel() {
        if (GeckoLibCache.getInstance().getGeoModels().containsKey(this.chairInfo.getModelId())) {
            return this.chairInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    public ResourceLocation getTexture() {
        return this.chairInfo.getTexture();
    }

    public ResourceLocation getAnimation() {
        if (GeckoLibCache.getInstance().getAnimations().containsKey(this.chairInfo.getModelId())) {
            return this.chairInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    public EntityChair getChair() {
        return this.chair;
    }

    public void setChair(EntityChair chair, ChairModelInfo chairInfo) {
        this.chair = chair;
        this.chairInfo = chairInfo;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    private PlayState predicateParallel(AnimationEvent<GeckoChairEntity> event, String animationName) {
        if (Minecraft.m_91087_().m_91104_()) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }
}

