/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class DownloadInfo {
    private static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private volatile DownloadStatus status = DownloadStatus.NOT_DOWNLOAD;
    @SerializedName(value="language")
    private HashMap<String, HashMap<String, String>> language = Maps.newHashMap();
    @SerializedName(value="author")
    private List<String> author = Lists.newArrayList();
    @SerializedName(value="file_name")
    private String fileName = "";
    @SerializedName(value="file_size")
    private long fileSize;
    @SerializedName(value="checksum")
    private long checksum;
    @SerializedName(value="upload_time")
    private long uploadTime;
    @SerializedName(value="name")
    private String name = "";
    @SerializedName(value="version")
    private String version = "";
    @SerializedName(value="url")
    private String url = "";
    @SerializedName(value="desc")
    private String desc = "";
    @SerializedName(value="license")
    private String license = "All Right Reserved";
    @SerializedName(value="website")
    private String website = "";
    @SerializedName(value="keyword")
    private String keyword = "";
    @SerializedName(value="old_version")
    private List<Long> oldVersion = Lists.newArrayList();
    @SerializedName(value="type")
    private List<String> type = Lists.newArrayList();
    @Expose(deserialize=false)
    private String formatFileSize = "";
    @Expose(deserialize=false)
    private String formatData;

    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDesc() {
        return this.desc;
    }

    public HashMap<String, HashMap<String, String>> getLanguages() {
        return this.language;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public void setStatus(DownloadStatus status) {
        this.status = status;
    }

    public String getFormatData() {
        return this.formatData;
    }

    public String getLicense() {
        return this.license;
    }

    public String getFormatFileSize() {
        return this.formatFileSize;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List<Long> getOldVersion() {
        return this.oldVersion;
    }

    public DownloadInfo decorate() {
        this.formatFileSize = DownloadInfo.readableFileSize(this.getFileSize());
        this.formatData = DATE_FORMAT.format(new Date(this.uploadTime));
        if (StringUtils.isNotBlank((CharSequence)this.keyword)) {
            this.keyword = this.keyword.toLowerCase(Locale.US);
        }
        return this;
    }

    public boolean hasType(TypeEnum typeEnum) {
        return this.type.contains(typeEnum.getName());
    }

    public int getTypeCount() {
        return this.type.size();
    }

    public static enum TypeEnum {
        MAID,
        CHAIR,
        SOUND;


        public static TypeEnum getTypeByIndex(int index) {
            return TypeEnum.values()[Mth.m_14045_((int)index, (int)0, (int)TypeEnum.values().length)];
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

