/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.inner;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public final class MaidExtraAnimation {
    private static final float[] FIXED_HAND_ROTATION = new float[]{0.0f, 0.0f, 0.0f};

    public static void init() {
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/arm/extra.js"), MaidExtraAnimation.getArmExtra());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/arm/vertical.js"), MaidExtraAnimation.getArmVertical());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/head/extra.js"), MaidExtraAnimation.getHeadExtra());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/head/hurt.js"), MaidExtraAnimation.getHeadHurt());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/head/reverse_blink.js"), MaidExtraAnimation.getHeadReverseBlink());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/leg/extra.js"), MaidExtraAnimation.getLegExtra());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/leg/vertical.js"), MaidExtraAnimation.getLegVertical());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/health/less_show.js"), MaidExtraAnimation.getHealthLessShow());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/health/more_show.js"), MaidExtraAnimation.getHealthMoreShow());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/default/health/rotation.js"), MaidExtraAnimation.getHealthRotation());
    }

    public static IAnimation<EntityMaid> getArmExtra() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                float[] rotation;
                ModelRendererWrapper armLeft = modelMap.get("armLeftExtraA");
                ModelRendererWrapper armRight = modelMap.get("armRightExtraA");
                double f1 = 1.0 - Math.pow(1.0 - (double)maid.f_20921_, 4.0);
                double f2 = Math.sin(f1 * Math.PI);
                double f3 = Math.sin((double)maid.f_20921_ * Math.PI) * -0.7 * 0.75;
                if (armLeft != null) {
                    if (MaidExtraAnimation.isHoldTrolley()) {
                        armLeft.setRotateAngleX(0.5f);
                        armLeft.setRotateAngleY(0.0f);
                        armLeft.setRotateAngleZ(-0.395f);
                    } else if (MaidExtraAnimation.isHoldVehicle()) {
                        rotation = MaidExtraAnimation.getLeftHandRotation();
                        armLeft.setRotateAngleX(rotation[0]);
                        armLeft.setRotateAngleY(rotation[1]);
                        armLeft.setRotateAngleZ(rotation[2]);
                    } else {
                        armLeft.setRotateAngleX((float)(-Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armLeft.setRotateAngleY(0.0f);
                        armLeft.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.05) * 0.05 - 0.4));
                        if ((double)maid.f_20921_ > 0.0 && MaidExtraAnimation.isSwingLeftHand(maid)) {
                            armLeft.setRotateAngleX((float)((double)armLeft.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armLeft.setRotateAngleZ((float)((double)armLeft.getRotateAngleZ() + Math.sin((double)maid.f_20921_ * Math.PI) * -0.4));
                        }
                        if (maid.m_6117_() && maid.m_7655_() == InteractionHand.OFF_HAND) {
                            armLeft.setRotateAngleX((float)((double)armLeft.getInitRotateAngleX() - 1.3962634015954636));
                            armLeft.setRotateAngleY((float)((double)armLeft.getInitRotateAngleY() + 0.4363323129985824));
                        }
                    }
                }
                if (armRight != null) {
                    if (MaidExtraAnimation.isHoldVehicle()) {
                        rotation = MaidExtraAnimation.getRightHandRotation();
                        armRight.setRotateAngleX(rotation[0]);
                        armRight.setRotateAngleY(rotation[1]);
                        armRight.setRotateAngleZ(rotation[2]);
                    } else {
                        armRight.setRotateAngleX((float)(Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armRight.setRotateAngleY(0.0f);
                        armRight.setRotateAngleZ((float)(-Math.cos((double)ageInTicks * 0.05) * 0.05 + 0.4));
                        if ((double)maid.f_20921_ > 0.0 && !MaidExtraAnimation.isSwingLeftHand(maid)) {
                            armRight.setRotateAngleX((float)((double)armRight.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armRight.setRotateAngleZ((float)((double)armRight.getRotateAngleZ() + Math.sin((double)maid.f_20921_ * Math.PI) * -0.4));
                        }
                        if (maid.m_6117_() && maid.m_7655_() == InteractionHand.MAIN_HAND) {
                            armRight.setRotateAngleX((float)((double)armRight.getInitRotateAngleX() - 1.3962634015954636));
                            armRight.setRotateAngleY((float)((double)armRight.getInitRotateAngleY() - 0.3490658503988659));
                        }
                    }
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getArmVertical() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper armLeftVertical = modelMap.get("armLeftVertical");
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                if (armLeftVertical != null && armLeft != null) {
                    armLeftVertical.setRotateAngleX(-armLeft.getRotateAngleX());
                    armLeftVertical.setRotateAngleZ(-armLeft.getRotateAngleZ());
                }
                ModelRendererWrapper armRightVertical = modelMap.get("armRightVertical");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                if (armRightVertical != null && armRight != null) {
                    armRightVertical.setRotateAngleX(-armRight.getRotateAngleX());
                    armRightVertical.setRotateAngleZ(-armRight.getRotateAngleZ());
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHeadExtra() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper headExtraC;
                ModelRendererWrapper headExtraB;
                ModelRendererWrapper headExtraA = modelMap.get("headExtraA");
                if (headExtraA != null) {
                    headExtraA.setRotateAngleX(headPitch * ((float)Math.PI / 180));
                    headExtraA.setRotateAngleY(netHeadYaw * ((float)Math.PI / 180));
                }
                if ((headExtraB = modelMap.get("headExtraB")) != null) {
                    headExtraB.setRotateAngleX(headPitch * ((float)Math.PI / 180));
                    headExtraB.setRotateAngleY(netHeadYaw * ((float)Math.PI / 180));
                }
                if ((headExtraC = modelMap.get("headExtraC")) != null) {
                    headExtraC.setRotateAngleX(headPitch * ((float)Math.PI / 180));
                    headExtraC.setRotateAngleY(netHeadYaw * ((float)Math.PI / 180));
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHeadHurt() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper hurtBlink = modelMap.get("hurtBlink");
                if (hurtBlink != null) {
                    hurtBlink.setHidden(!maid.onHurt());
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHeadReverseBlink() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper reverseBlink = modelMap.get("_bink");
                ModelRendererWrapper reverseBlinkCorrect = modelMap.get("_blink");
                if (reverseBlink != null) {
                    float remainder = (ageInTicks + (float)(Math.abs(maid.m_20148_().getLeastSignificantBits()) % 10L)) % 60.0f;
                    reverseBlink.setHidden(55.0f < remainder && remainder < 60.0f);
                    reverseBlinkCorrect.setHidden(55.0f < remainder && remainder < 60.0f);
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getLegExtra() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper legLeftExtraA = modelMap.get("legLeftExtraA");
                ModelRendererWrapper legRightExtraA = modelMap.get("legRightExtraA");
                if (legLeftExtraA != null) {
                    legLeftExtraA.setRotateAngleX((float)(Math.cos((double)limbSwing * 0.67) * 0.3 * (double)limbSwingAmount));
                    legLeftExtraA.setRotateAngleY(0.0f);
                    legLeftExtraA.setRotateAngleZ(0.0f);
                }
                if (legRightExtraA != null) {
                    legRightExtraA.setRotateAngleX((float)(-Math.cos((double)limbSwing * 0.67) * 0.3 * (double)limbSwingAmount));
                    legRightExtraA.setRotateAngleY(0.0f);
                    legRightExtraA.setRotateAngleZ(0.0f);
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getLegVertical() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper legLeftVertical = modelMap.get("legLeftVertical");
                ModelRendererWrapper legLeft = modelMap.get("legLeft");
                if (legLeftVertical != null && legLeft != null) {
                    legLeftVertical.setRotateAngleX(-legLeft.getRotateAngleX());
                    legLeftVertical.setRotateAngleZ(-legLeft.getRotateAngleZ());
                }
                ModelRendererWrapper legRightVertical = modelMap.get("legRightVertical");
                ModelRendererWrapper legRight = modelMap.get("legRight");
                if (legRightVertical != null && legRight != null) {
                    legRightVertical.setRotateAngleX(-legRight.getRotateAngleX());
                    legRightVertical.setRotateAngleZ(-legRight.getRotateAngleZ());
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHealthLessShow() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper healthLessQuarterShow = modelMap.get("healthLessQuarterShow");
                ModelRendererWrapper healthLessHalfShow = modelMap.get("healthLessHalfShow");
                ModelRendererWrapper healthLessThreeQuartersShow = modelMap.get("healthLessThreeQuartersShow");
                double ratio = maid.m_21223_() / maid.m_21233_();
                if (healthLessQuarterShow != null) {
                    healthLessQuarterShow.setHidden(ratio > 0.25);
                }
                if (healthLessHalfShow != null) {
                    healthLessHalfShow.setHidden(ratio > 0.5);
                }
                if (healthLessThreeQuartersShow != null) {
                    healthLessThreeQuartersShow.setHidden(ratio > 0.75);
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHealthMoreShow() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper healthMoreQuarterShow = modelMap.get("healthMoreQuarterShow");
                ModelRendererWrapper healthMoreHalfShow = modelMap.get("healthMoreHalfShow");
                ModelRendererWrapper healthMoreThreeQuartersShow = modelMap.get("healthMoreThreeQuartersShow");
                double ratio = maid.m_21223_() / maid.m_21233_();
                if (healthMoreQuarterShow != null) {
                    healthMoreQuarterShow.setHidden(ratio <= 0.25);
                }
                if (healthMoreHalfShow != null) {
                    healthMoreHalfShow.setHidden(ratio <= 0.5);
                }
                if (healthMoreThreeQuartersShow != null) {
                    healthMoreThreeQuartersShow.setHidden(ratio <= 0.75);
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getHealthRotation() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper healthRotationX90 = modelMap.get("healthRotationX90");
                if (healthRotationX90 != null) {
                    double deg = 0.7853981633974483 - 1.5707963267948966 * (double)(maid.m_21223_() / maid.m_21233_());
                    healthRotationX90.setRotateAngleX((float)deg);
                }
            }
        };
    }

    private static boolean isSwingLeftHand(EntityMaid maid) {
        return maid.f_20912_ == InteractionHand.OFF_HAND;
    }

    @Deprecated
    public static boolean isPassengerMarisaBroom(EntityMaid maid) {
        return false;
    }

    @Deprecated
    private static boolean isPortableAudioPlay() {
        return false;
    }

    @Deprecated
    private static boolean isHoldTrolley() {
        return false;
    }

    @Deprecated
    private static boolean isHoldVehicle() {
        return false;
    }

    @Deprecated
    private static float[] getLeftHandRotation() {
        return FIXED_HAND_ROTATION;
    }

    @Deprecated
    private static float[] getRightHandRotation() {
        return FIXED_HAND_ROTATION;
    }
}

