/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionArmor;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalHold;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalSwing;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalUse;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class AnimationManager {
    private static AnimationManager MANAGER;
    private final ReferenceArrayList<AnimationState>[] data = new ReferenceArrayList[5];

    public AnimationManager() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ReferenceArrayList(6);
        }
    }

    public static AnimationManager getInstance() {
        if (MANAGER == null) {
            MANAGER = new AnimationManager();
        }
        return MANAGER;
    }

    @Nonnull
    public static <P extends IAnimatable> PlayState playLoopAnimation(AnimationEvent<P> event, String animationName) {
        return AnimationManager.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @Nonnull
    private static <P extends IAnimatable> PlayState playAnimation(AnimationEvent<P> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    @Nonnull
    private static <P extends IAnimatable> PlayState playAnimation(AnimationEvent<P> event, String animationName) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName));
        return PlayState.CONTINUE;
    }

    public void register(AnimationState state) {
        this.data[state.getPriority()].add((Object)state);
    }

    public PlayState predicateParallel(AnimationEvent<GeckoMaidEntity> event, String animationName) {
        if (Minecraft.m_91087_().m_91104_()) {
            return PlayState.STOP;
        }
        return AnimationManager.playLoopAnimation(event, animationName);
    }

    @NotNull
    public PlayState predicateMain(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        for (int i = 0; i <= 4; ++i) {
            for (AnimationState state : this.data[i]) {
                if (!state.getPredicate().test(maid, event)) continue;
                String animationName = state.getAnimationName();
                ILoopType loopType = state.getLoopType();
                return AnimationManager.playAnimation(event, animationName, loopType);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateOffhandHold(AnimationEvent<GeckoMaidEntity> event) {
        ItemStack offhandItem;
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.f_20911_ && !maid.m_6117_() && (offhandItem = maid.m_21120_(InteractionHand.OFF_HAND)).m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)offhandItem)) {
            return AnimationManager.playAnimation(event, "hold_offhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
        }
        if (this.checkSwingAndUse(maid, InteractionHand.OFF_HAND)) {
            String name;
            ResourceLocation id;
            ConditionalHold conditionalHold;
            offhandItem = maid.m_21120_(InteractionHand.OFF_HAND);
            if (!this.isSameItem(maid, offhandItem, InteractionHand.OFF_HAND)) {
                maid.handItemsForAnimation[InteractionHand.OFF_HAND.ordinal()] = offhandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldOffhand(id = event.getAnimatable().getAnimation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, InteractionHand.OFF_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateMainhandHold(AnimationEvent<GeckoMaidEntity> event) {
        ItemStack mainHandItem;
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.f_20911_ && !maid.m_6117_() && (mainHandItem = maid.m_21120_(InteractionHand.MAIN_HAND)).m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)mainHandItem)) {
            return AnimationManager.playAnimation(event, "hold_mainhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
        }
        if (this.checkSwingAndUse(maid, InteractionHand.MAIN_HAND)) {
            String name;
            ResourceLocation id;
            ConditionalHold conditionalHold;
            mainHandItem = maid.m_21120_(InteractionHand.MAIN_HAND);
            if (!this.isSameItem(maid, mainHandItem, InteractionHand.MAIN_HAND)) {
                maid.handItemsForAnimation[InteractionHand.MAIN_HAND.ordinal()] = mainHandItem;
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.LOOP);
            }
            if ((conditionalHold = ConditionManager.getHoldMainhand(id = event.getAnimatable().getAnimation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, InteractionHand.MAIN_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        return PlayState.STOP;
    }

    private boolean isSameItem(EntityMaid maid, ItemStack maidItem, InteractionHand hand) {
        ItemStack preItem = maid.handItemsForAnimation[hand.ordinal()];
        if (preItem.m_41768_()) {
            return ItemStack.m_41746_((ItemStack)maidItem, (ItemStack)preItem);
        }
        return ItemStack.m_41728_((ItemStack)maidItem, (ItemStack)preItem);
    }

    public PlayState predicateSwing(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.f_20911_ && !maid.m_5803_()) {
            String name;
            ConditionalSwing conditionalSwing;
            if (maid.f_20913_ == 0) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            ResourceLocation id = event.getAnimatable().getAnimation();
            ConditionalSwing conditionalSwing2 = conditionalSwing = maid.f_20912_ == InteractionHand.MAIN_HAND ? ConditionManager.getSwingMainhand(id) : ConditionManager.getSwingOffhand(id);
            if (conditionalSwing != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalSwing.doTest(maid, maid.f_20912_)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            String defaultSwing = maid.f_20912_ == InteractionHand.MAIN_HAND ? "swing_hand" : "swing_offhand";
            return AnimationManager.playAnimation(event, defaultSwing, ILoopType.EDefaultLoopTypes.PLAY_ONCE);
        }
        return PlayState.CONTINUE;
    }

    public PlayState predicateUse(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.m_6117_() && !maid.m_5803_()) {
            String name;
            if (maid.m_21252_() == 1) {
                AnimationManager.playAnimation(event, "empty", ILoopType.EDefaultLoopTypes.PLAY_ONCE);
            }
            if (maid.m_7655_() == InteractionHand.MAIN_HAND) {
                String name2;
                ResourceLocation id = event.getAnimatable().getAnimation();
                ConditionalUse conditionalUse = ConditionManager.getUseMainhand(id);
                if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name2 = conditionalUse.doTest(maid, InteractionHand.MAIN_HAND)})) {
                    return AnimationManager.playAnimation(event, name2, ILoopType.EDefaultLoopTypes.LOOP);
                }
                return AnimationManager.playAnimation(event, "use_mainhand", ILoopType.EDefaultLoopTypes.LOOP);
            }
            ResourceLocation id = event.getAnimatable().getAnimation();
            ConditionalUse conditionalUse = ConditionManager.getUseOffhand(id);
            if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalUse.doTest(maid, InteractionHand.OFF_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
            return AnimationManager.playAnimation(event, "use_offhand", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateBeg(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.isBegging()) {
            return AnimationManager.playAnimation(event, "beg", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateArmor(AnimationEvent<GeckoMaidEntity> event, EquipmentSlot slot) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        ItemStack itemBySlot = maid.m_6844_(slot);
        if (itemBySlot.m_41619_()) {
            return PlayState.STOP;
        }
        ResourceLocation id = event.getAnimatable().getAnimation();
        ConditionArmor conditionArmor = ConditionManager.getArmor(id);
        if (conditionArmor != null) {
            String name = conditionArmor.doTest(maid, slot);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        ResourceLocation animation = event.getAnimatable().getAnimation();
        String defaultName = slot.m_20751_() + ":default";
        if (GeckoLibCache.getInstance().getAnimations().get(animation).animations().containsKey(defaultName)) {
            return AnimationManager.playAnimation(event, defaultName, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    private boolean checkSwingAndUse(EntityMaid maid, InteractionHand hand) {
        if (maid.f_20911_ && maid.f_20912_ == hand) {
            return false;
        }
        return !maid.m_6117_() || maid.m_7655_() != hand;
    }
}

